/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.discovery.SeedHostsResolver;
import org.elasticsearch.discovery.zen.PingContextProvider;
import org.elasticsearch.discovery.zen.ZenPing;
import org.elasticsearch.node.Node;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class UnicastZenPing
implements ZenPing {
    private static final Logger logger = LogManager.getLogger(UnicastZenPing.class);
    public static final String ACTION_NAME = "internal:discovery/zen/unicast";
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterName clusterName;
    private final PingContextProvider contextProvider;
    private final AtomicInteger pingingRoundIdGenerator = new AtomicInteger();
    private final Map<Integer, PingingRound> activePingingRounds = ConcurrentCollections.newConcurrentMap();
    private final Queue<ZenPing.PingResponse> temporalResponses = ConcurrentCollections.newQueue();
    private final SeedHostsProvider hostsProvider;
    protected final EsThreadPoolExecutor unicastZenPingExecutorService;
    private final TimeValue resolveTimeout;
    private final String nodeName;
    private volatile boolean closed = false;

    public UnicastZenPing(Settings settings, ThreadPool threadPool, TransportService transportService, SeedHostsProvider seedHostsProvider, PingContextProvider contextProvider) {
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.hostsProvider = seedHostsProvider;
        this.contextProvider = contextProvider;
        int concurrentConnects = SeedHostsResolver.getMaxConcurrentResolvers(settings);
        this.resolveTimeout = SeedHostsResolver.getResolveTimeout(settings);
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
        logger.debug("using max_concurrent_resolvers [{}], resolver timeout [{}]", (Object)concurrentConnects, (Object)this.resolveTimeout);
        transportService.registerRequestHandler(ACTION_NAME, "same", UnicastPingRequest::new, new UnicastPingRequestHandler());
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(settings, "[unicast_connect]");
        this.unicastZenPingExecutorService = EsExecutors.newScaling(this.nodeName + "/unicast_connect", 0, concurrentConnects, 60L, TimeUnit.SECONDS, threadFactory, threadPool.getThreadContext());
    }

    private SeedHostsProvider.HostsResolver createHostsResolver() {
        return (hosts, limitPortCounts) -> SeedHostsResolver.resolveHostsLists(this.unicastZenPingExecutorService, logger, hosts, limitPortCounts, this.transportService, this.resolveTimeout);
    }

    @Override
    public void close() {
        ThreadPool.terminate(this.unicastZenPingExecutorService, 10L, TimeUnit.SECONDS);
        Releasables.close(this.activePingingRounds.values());
        this.closed = true;
    }

    @Override
    public void start() {
    }

    public void clearTemporalResponses() {
        this.temporalResponses.clear();
    }

    @Override
    public void ping(Consumer<ZenPing.PingCollection> resultsConsumer, TimeValue duration) {
        this.ping(resultsConsumer, duration, duration);
    }

    protected void ping(Consumer<ZenPing.PingCollection> resultsConsumer, TimeValue scheduleDuration, final TimeValue requestDuration) {
        ArrayList<TransportAddress> seedAddresses = new ArrayList<TransportAddress>();
        seedAddresses.addAll(this.hostsProvider.getSeedAddresses(this.createHostsResolver()));
        DiscoveryNodes nodes = this.contextProvider.clusterState().nodes();
        for (ObjectCursor masterNode : nodes.getMasterNodes().values()) {
            seedAddresses.add(((DiscoveryNode)masterNode.value).getAddress());
        }
        ConnectionProfile connectionProfile = ConnectionProfile.buildSingleChannelProfile(TransportRequestOptions.Type.REG, requestDuration, requestDuration);
        final PingingRound pingingRound = new PingingRound(this.pingingRoundIdGenerator.incrementAndGet(), seedAddresses, resultsConsumer, nodes.getLocalNode(), connectionProfile);
        this.activePingingRounds.put(pingingRound.id(), pingingRound);
        AbstractRunnable pingSender = new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                if (!(e instanceof AlreadyClosedException)) {
                    logger.warn("unexpected error while pinging", (Throwable)e);
                }
            }

            @Override
            protected void doRun() throws Exception {
                UnicastZenPing.this.sendPings(requestDuration, pingingRound);
            }
        };
        this.threadPool.generic().execute(pingSender);
        this.threadPool.schedule(pingSender, TimeValue.timeValueMillis(scheduleDuration.millis() / 3L), "generic");
        this.threadPool.schedule(pingSender, TimeValue.timeValueMillis(scheduleDuration.millis() / 3L * 2L), "generic");
        this.threadPool.schedule(new AbstractRunnable(){

            @Override
            protected void doRun() throws Exception {
                UnicastZenPing.this.finishPingingRound(pingingRound);
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn("unexpected error while finishing pinging round", (Throwable)e);
            }
        }, scheduleDuration, "generic");
    }

    protected void finishPingingRound(PingingRound pingingRound) {
        pingingRound.close();
    }

    protected void sendPings(TimeValue timeout, PingingRound pingingRound) {
        ClusterState lastState = this.contextProvider.clusterState();
        UnicastPingRequest pingRequest = new UnicastPingRequest(pingingRound.id(), timeout, this.createPingResponse(lastState));
        List temporalAddresses = this.temporalResponses.stream().map(pingResponse -> {
            assert (this.clusterName.equals(pingResponse.clusterName())) : "got a ping request from a different cluster. expected " + this.clusterName + " got " + pingResponse.clusterName();
            return pingResponse.node().getAddress();
        }).collect(Collectors.toList());
        Stream uniqueAddresses = Stream.concat(pingingRound.getSeedAddresses().stream(), temporalAddresses.stream()).distinct();
        Set<DiscoveryNode> nodesToPing = uniqueAddresses.map(address -> {
            DiscoveryNode foundNode = lastState.nodes().findByAddress((TransportAddress)address);
            if (foundNode != null && this.transportService.nodeConnected(foundNode)) {
                return foundNode;
            }
            return new DiscoveryNode(address.toString(), (TransportAddress)address, Collections.emptyMap(), Collections.emptySet(), Version.CURRENT.minimumCompatibilityVersion());
        }).collect(Collectors.toSet());
        nodesToPing.forEach(node -> this.sendPingRequestToNode((DiscoveryNode)node, timeout, pingingRound, pingRequest));
    }

    private void sendPingRequestToNode(final DiscoveryNode node, final TimeValue timeout, final PingingRound pingingRound, final UnicastPingRequest pingRequest) {
        this.submitToExecutor(new AbstractRunnable(){

            @Override
            protected void doRun() throws Exception {
                Transport.Connection connection = null;
                if (UnicastZenPing.this.transportService.nodeConnected(node)) {
                    try {
                        connection = UnicastZenPing.this.transportService.getConnection(node);
                    }
                    catch (NodeNotConnectedException e) {
                        logger.trace("[{}] node [{}] just disconnected, will create a temp connection", (Object)pingingRound.id(), (Object)node);
                    }
                }
                if (connection == null) {
                    connection = pingingRound.getOrConnect(node);
                }
                logger.trace("[{}] sending to {}", (Object)pingingRound.id(), (Object)node);
                UnicastZenPing.this.transportService.sendRequest(connection, UnicastZenPing.ACTION_NAME, (TransportRequest)pingRequest, TransportRequestOptions.builder().withTimeout((long)((double)timeout.millis() * 1.25)).build(), UnicastZenPing.this.getPingResponseHandler(pingingRound, node));
            }

            @Override
            public void onFailure(Exception e) {
                if (e instanceof ConnectTransportException || e instanceof AlreadyClosedException) {
                    logger.trace(() -> new ParameterizedMessage("[{}] failed to ping {}", (Object)pingingRound.id(), (Object)node), (Throwable)e);
                } else if (e instanceof RemoteTransportException) {
                    logger.debug(() -> new ParameterizedMessage("[{}] received a remote error as a response to ping {}", (Object)pingingRound.id(), (Object)node), (Throwable)e);
                } else {
                    logger.warn(() -> new ParameterizedMessage("[{}] failed send ping to {}", (Object)pingingRound.id(), (Object)node), (Throwable)e);
                }
            }

            @Override
            public void onRejection(Exception e) {
                logger.debug("Ping execution rejected", (Throwable)e);
            }
        });
    }

    protected void submitToExecutor(AbstractRunnable abstractRunnable) {
        this.unicastZenPingExecutorService.execute(abstractRunnable);
    }

    protected TransportResponseHandler<UnicastPingResponse> getPingResponseHandler(final PingingRound pingingRound, final DiscoveryNode node) {
        return new TransportResponseHandler<UnicastPingResponse>(){

            @Override
            public UnicastPingResponse read(StreamInput in) throws IOException {
                return new UnicastPingResponse(in);
            }

            @Override
            public String executor() {
                return "same";
            }

            @Override
            public void handleResponse(UnicastPingResponse response) {
                logger.trace("[{}] received response from {}: {}", (Object)pingingRound.id(), (Object)node, (Object)Arrays.toString(response.pingResponses));
                if (pingingRound.isClosed()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("[{}] skipping received response from {}. already closed", (Object)pingingRound.id(), (Object)node);
                    }
                } else {
                    Stream.of(response.pingResponses).forEach(pingingRound::addPingResponseToCollection);
                }
            }

            @Override
            public void handleException(TransportException exp) {
                if (exp instanceof ConnectTransportException || exp.getCause() instanceof ConnectTransportException || exp.getCause() instanceof AlreadyClosedException) {
                    logger.trace(() -> new ParameterizedMessage("failed to connect to {}", (Object)node), (Throwable)exp);
                } else if (!UnicastZenPing.this.closed) {
                    logger.warn(() -> new ParameterizedMessage("failed to send ping to [{}]", (Object)node), (Throwable)exp);
                }
            }
        };
    }

    private UnicastPingResponse handlePingRequest(UnicastPingRequest request) {
        assert (this.clusterName.equals(request.pingResponse.clusterName())) : "got a ping request from a different cluster. expected " + this.clusterName + " got " + request.pingResponse.clusterName();
        this.temporalResponses.add(request.pingResponse);
        this.activePingingRounds.values().forEach(p -> p.addPingResponseToCollection(request.pingResponse));
        this.threadPool.schedule(() -> this.temporalResponses.remove(request.pingResponse), TimeValue.timeValueMillis(request.timeout.millis() * 2L), "same");
        ArrayList<ZenPing.PingResponse> pingResponses = CollectionUtils.iterableAsArrayList(this.temporalResponses);
        pingResponses.add(this.createPingResponse(this.contextProvider.clusterState()));
        return new UnicastPingResponse(request.id, pingResponses.toArray(new ZenPing.PingResponse[pingResponses.size()]));
    }

    private ZenPing.PingResponse createPingResponse(ClusterState clusterState) {
        DiscoveryNodes discoNodes = clusterState.nodes();
        return new ZenPing.PingResponse(discoNodes.getLocalNode(), discoNodes.getMasterNode(), clusterState);
    }

    protected Version getVersion() {
        return Version.CURRENT;
    }

    public static class UnicastPingResponse
    extends TransportResponse {
        final int id;
        public final ZenPing.PingResponse[] pingResponses;

        public UnicastPingResponse(int id, ZenPing.PingResponse[] pingResponses) {
            this.id = id;
            this.pingResponses = pingResponses;
        }

        public UnicastPingResponse(StreamInput in) throws IOException {
            this.id = in.readInt();
            this.pingResponses = new ZenPing.PingResponse[in.readVInt()];
            for (int i = 0; i < this.pingResponses.length; ++i) {
                this.pingResponses[i] = new ZenPing.PingResponse(in);
            }
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.id);
            out.writeVInt(this.pingResponses.length);
            for (ZenPing.PingResponse pingResponse : this.pingResponses) {
                pingResponse.writeTo(out);
            }
        }
    }

    public static class UnicastPingRequest
    extends TransportRequest {
        public final int id;
        public final TimeValue timeout;
        public final ZenPing.PingResponse pingResponse;

        public UnicastPingRequest(int id, TimeValue timeout, ZenPing.PingResponse pingResponse) {
            this.id = id;
            this.timeout = timeout;
            this.pingResponse = pingResponse;
        }

        public UnicastPingRequest(StreamInput in) throws IOException {
            super(in);
            this.id = in.readInt();
            this.timeout = in.readTimeValue();
            this.pingResponse = new ZenPing.PingResponse(in);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.id);
            out.writeTimeValue(this.timeout);
            this.pingResponse.writeTo(out);
        }
    }

    class UnicastPingRequestHandler
    implements TransportRequestHandler<UnicastPingRequest> {
        UnicastPingRequestHandler() {
        }

        @Override
        public void messageReceived(UnicastPingRequest request, TransportChannel channel, Task task) throws Exception {
            if (UnicastZenPing.this.closed) {
                throw new AlreadyClosedException("node is shutting down");
            }
            if (!request.pingResponse.clusterName().equals(UnicastZenPing.this.clusterName)) {
                throw new IllegalStateException(String.format(Locale.ROOT, "mismatched cluster names; request: [%s], local: [%s]", request.pingResponse.clusterName().value(), UnicastZenPing.this.clusterName.value()));
            }
            channel.sendResponse(UnicastZenPing.this.handlePingRequest(request));
        }
    }

    protected class PingingRound
    implements Releasable {
        private final int id;
        private final Map<TransportAddress, Transport.Connection> tempConnections = new HashMap<TransportAddress, Transport.Connection>();
        private final KeyedLock<TransportAddress> connectionLock = new KeyedLock(true);
        private final ZenPing.PingCollection pingCollection;
        private final List<TransportAddress> seedAddresses;
        private final Consumer<ZenPing.PingCollection> pingListener;
        private final DiscoveryNode localNode;
        private final ConnectionProfile connectionProfile;
        private AtomicBoolean closed = new AtomicBoolean(false);

        PingingRound(int id, List<TransportAddress> seedAddresses, Consumer<ZenPing.PingCollection> resultsConsumer, DiscoveryNode localNode, ConnectionProfile connectionProfile) {
            this.id = id;
            this.seedAddresses = Collections.unmodifiableList(seedAddresses.stream().distinct().collect(Collectors.toList()));
            this.pingListener = resultsConsumer;
            this.localNode = localNode;
            this.connectionProfile = connectionProfile;
            this.pingCollection = new ZenPing.PingCollection();
        }

        public int id() {
            return this.id;
        }

        public boolean isClosed() {
            return this.closed.get();
        }

        public List<TransportAddress> getSeedAddresses() {
            this.ensureOpen();
            return this.seedAddresses;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transport.Connection getOrConnect(DiscoveryNode node) throws IOException {
            Transport.Connection result;
            block13: {
                try (Releasable ignore = this.connectionLock.acquire(node.getAddress());){
                    result = this.tempConnections.get(node.getAddress());
                    if (result != null) break block13;
                    this.ensureOpen();
                    boolean success = false;
                    logger.trace("[{}] opening connection to [{}]", (Object)this.id(), (Object)node);
                    result = UnicastZenPing.this.transportService.openConnection(node, this.connectionProfile);
                    try {
                        UnicastZenPing.this.transportService.handshake(result, this.connectionProfile.getHandshakeTimeout().millis());
                        PingingRound pingingRound = this;
                        synchronized (pingingRound) {
                            this.ensureOpen();
                            Transport.Connection existing = this.tempConnections.put(node.getAddress(), result);
                            assert (existing == null);
                            success = true;
                        }
                        if (success) break block13;
                        logger.trace("[{}] closing connection to [{}] due to failure", (Object)this.id(), (Object)node);
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            logger.trace("[{}] closing connection to [{}] due to failure", (Object)this.id(), (Object)node);
                            IOUtils.closeWhileHandlingException(result);
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException(result);
                }
            }
            return result;
        }

        private void ensureOpen() {
            if (this.isClosed()) {
                throw new AlreadyClosedException("pinging round [" + this.id + "] is finished");
            }
        }

        public void addPingResponseToCollection(ZenPing.PingResponse pingResponse) {
            if (!this.localNode.equals(pingResponse.node())) {
                this.pingCollection.addPing(pingResponse);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ArrayList<Transport.Connection> toClose = null;
            PingingRound pingingRound = this;
            synchronized (pingingRound) {
                if (this.closed.compareAndSet(false, true)) {
                    UnicastZenPing.this.activePingingRounds.remove(this.id);
                    toClose = new ArrayList<Transport.Connection>(this.tempConnections.values());
                    this.tempConnections.clear();
                }
            }
            if (toClose != null) {
                try {
                    this.pingListener.accept(this.pingCollection);
                }
                finally {
                    IOUtils.closeWhileHandlingException(toClose);
                }
            }
        }

        public ConnectionProfile getConnectionProfile() {
            return this.connectionProfile;
        }
    }
}

