/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.discovery.SeedHostsProvider;

public class FileBasedSeedHostsProvider
implements SeedHostsProvider {
    private static final Logger logger = LogManager.getLogger(FileBasedSeedHostsProvider.class);
    public static final String UNICAST_HOSTS_FILE = "unicast_hosts.txt";
    private final Path unicastHostsFilePath;

    public FileBasedSeedHostsProvider(Path configFile) {
        this.unicastHostsFilePath = configFile.resolve(UNICAST_HOSTS_FILE);
    }

    private List<String> getHostsList() {
        if (Files.exists(this.unicastHostsFilePath, new LinkOption[0])) {
            List<String> list;
            block9: {
                Stream<String> lines = Files.lines(this.unicastHostsFilePath);
                try {
                    list = lines.filter(line -> !line.startsWith("#")).collect(Collectors.toList());
                    if (lines == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (lines != null) {
                            try {
                                lines.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.warn(() -> new ParameterizedMessage("failed to read file [{}]", (Object)this.unicastHostsFilePath), (Throwable)e);
                        return Collections.emptyList();
                    }
                }
                lines.close();
            }
            return list;
        }
        logger.warn("expected, but did not find, a dynamic hosts list at [{}]", (Object)this.unicastHostsFilePath);
        return Collections.emptyList();
    }

    @Override
    public List<TransportAddress> getSeedAddresses(SeedHostsProvider.HostsResolver hostsResolver) {
        List<TransportAddress> transportAddresses = hostsResolver.resolveHosts(this.getHostsList(), 1);
        logger.debug("seed addresses: {}", (Object)transportAddresses);
        return transportAddresses;
    }
}

