/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.MinScoreScorer;
import org.elasticsearch.common.lucene.search.function.ScriptScoreFunction;

public class ScriptScoreQuery
extends Query {
    final Query subQuery;
    final ScriptScoreFunction function;
    private final Float minScore;

    public ScriptScoreQuery(Query subQuery, ScriptScoreFunction function, Float minScore) {
        this.subQuery = subQuery;
        this.function = function;
        this.minScore = minScore;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.subQuery.rewrite(reader);
        ScriptScoreFunction newFunction = (ScriptScoreFunction)this.function.rewrite(reader);
        if (newQ != this.subQuery || newFunction != this.function) {
            return new ScriptScoreQuery(newQ, newFunction, this.minScore);
        }
        return super.rewrite(reader);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (scoreMode == ScoreMode.COMPLETE_NO_SCORES && this.minScore == null) {
            return this.subQuery.createWeight(searcher, scoreMode, boost);
        }
        final ScoreMode subQueryScoreMode = this.function.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        final Weight subQueryWeight = this.subQuery.createWeight(searcher, subQueryScoreMode, boost);
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
                subQueryWeight.extractTerms(terms);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final Scorer subQueryScorer = subQueryWeight.scorer(context);
                if (subQueryScorer == null) {
                    return null;
                }
                final LeafScoreFunction leafFunction = ScriptScoreQuery.this.function.getLeafScoreFunction(context);
                Scorer scriptScorer = new Scorer(this){

                    @Override
                    public float score() throws IOException {
                        float subQueryScore;
                        int docId = this.docID();
                        float score = (float)leafFunction.score(docId, subQueryScore = subQueryScoreMode == ScoreMode.COMPLETE ? subQueryScorer.score() : 0.0f);
                        if (score == Float.NEGATIVE_INFINITY || Float.isNaN(score)) {
                            throw new ElasticsearchException("script score query returned an invalid score: " + score + " for doc: " + docId, new Object[0]);
                        }
                        return score;
                    }

                    @Override
                    public int docID() {
                        return subQueryScorer.docID();
                    }

                    @Override
                    public DocIdSetIterator iterator() {
                        return subQueryScorer.iterator();
                    }

                    @Override
                    public float getMaxScore(int upTo) {
                        return Float.MAX_VALUE;
                    }
                };
                if (ScriptScoreQuery.this.minScore != null) {
                    scriptScorer = new MinScoreScorer(this, scriptScorer, ScriptScoreQuery.this.minScore.floatValue());
                }
                return scriptScorer;
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Explanation queryExplanation = subQueryWeight.explain(context, doc);
                if (!queryExplanation.isMatch()) {
                    return queryExplanation;
                }
                Explanation explanation = ScriptScoreQuery.this.function.getLeafScoreFunction(context).explainScore(doc, queryExplanation);
                if (ScriptScoreQuery.this.minScore != null && ScriptScoreQuery.this.minScore.floatValue() > explanation.getValue().floatValue()) {
                    explanation = Explanation.noMatch("Score value is too low, expected at least " + ScriptScoreQuery.this.minScore + " but got " + explanation.getValue(), explanation);
                }
                return explanation;
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return ScriptScoreQuery.this.minScore == null;
            }
        };
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("script score (").append(this.subQuery.toString(field)).append(", function: ");
        sb.append("{" + (this.function == null ? "" : this.function.toString()) + "}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        ScriptScoreQuery other = (ScriptScoreQuery)o;
        return Objects.equals(this.subQuery, other.subQuery) && Objects.equals(this.minScore, other.minScore) && Objects.equals(this.function, other.function);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.subQuery, this.minScore, this.function);
    }
}

