/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.nio.charset.Charset;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.elasticsearch.common.Strings;

@Plugin(name="ESJsonLayout", category="Core", elementType="layout", printObject=true)
public class ESJsonLayout
extends AbstractStringLayout {
    private static final String PATTERN = "{\"type\": \"${TYPE}\", \"timestamp\": \"%d{yyyy-MM-dd'T'HH:mm:ss,SSSZ}\", \"level\": \"%p\", \"component\": \"%c{1.}\", \"cluster.name\": \"${sys:es.logs.cluster_name}\", \"node.name\": \"%node_name\", %notEmpty{%node_and_cluster_id, } \"message\": \"%notEmpty{%enc{%marker}{JSON} }%enc{%.-10000m}{JSON}\" %exceptionAsJson }%n";
    private final PatternLayout patternLayout;

    protected ESJsonLayout(String typeName, Charset charset) {
        super(charset);
        this.patternLayout = PatternLayout.newBuilder().withPattern(this.pattern(typeName)).withAlwaysWriteExceptions(false).build();
    }

    private String pattern(String type) {
        if (Strings.isEmpty(type)) {
            throw new IllegalArgumentException("layout parameter 'type_name' cannot be empty");
        }
        return PATTERN.replace("${TYPE}", type);
    }

    @PluginFactory
    public static ESJsonLayout createLayout(@PluginAttribute(value="type_name") String type, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset) {
        return new ESJsonLayout(type, charset);
    }

    @Override
    public String toSerializable(LogEvent event) {
        return this.patternLayout.toSerializable(event);
    }

    @Override
    public Map<String, String> getContentFormat() {
        return this.patternLayout.getContentFormat();
    }

    @Override
    public void encode(LogEvent event, ByteBufferDestination destination) {
        this.patternLayout.encode(event, destination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ESJsonLayout{");
        sb.append("patternLayout=").append(this.patternLayout);
        sb.append('}');
        return sb.toString();
    }
}

