/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.function.ToIntBiFunction;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.ByteBufferReference;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReferenceStreamInput;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class BytesReference
implements Comparable<BytesReference>,
ToXContentFragment {
    private Integer hash = null;

    public static BytesReference bytes(XContentBuilder xContentBuilder) {
        xContentBuilder.close();
        OutputStream stream = xContentBuilder.getOutputStream();
        if (stream instanceof ByteArrayOutputStream) {
            return new BytesArray(((ByteArrayOutputStream)stream).toByteArray());
        }
        return ((BytesStream)stream).bytes();
    }

    public abstract byte get(int var1);

    public abstract int length();

    public abstract BytesReference slice(int var1, int var2);

    public abstract long ramBytesUsed();

    public StreamInput streamInput() throws IOException {
        return new MarkSupportingStreamInputWrapper(this);
    }

    public void writeTo(OutputStream os) throws IOException {
        BytesRef ref;
        BytesRefIterator iterator = this.iterator();
        while ((ref = iterator.next()) != null) {
            os.write(ref.bytes, ref.offset, ref.length);
        }
    }

    public String utf8ToString() {
        return this.toBytesRef().utf8ToString();
    }

    public abstract BytesRef toBytesRef();

    public BytesRefIterator iterator() {
        return new BytesRefIterator(){
            BytesRef ref;
            {
                this.ref = BytesReference.this.length() == 0 ? null : BytesReference.this.toBytesRef();
            }

            @Override
            public BytesRef next() throws IOException {
                BytesRef r = this.ref;
                this.ref = null;
                return r;
            }
        };
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BytesReference) {
            BytesReference otherRef = (BytesReference)other;
            if (this.length() != otherRef.length()) {
                return false;
            }
            return BytesReference.compareIterators(this, otherRef, (a, b) -> a.bytesEquals((BytesRef)b) ? 0 : 1) == 0;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == null) {
            BytesRefIterator iterator = this.iterator();
            int result = 1;
            try {
                BytesRef ref;
                while ((ref = iterator.next()) != null) {
                    for (int i = 0; i < ref.length; ++i) {
                        result = 31 * result + ref.bytes[ref.offset + i];
                    }
                }
            }
            catch (IOException ex) {
                throw new AssertionError("wont happen", ex);
            }
            this.hash = result;
            return this.hash;
        }
        return this.hash;
    }

    public static byte[] toBytes(BytesReference reference) {
        BytesRef bytesRef = reference.toBytesRef();
        if (bytesRef.offset == 0 && bytesRef.length == bytesRef.bytes.length) {
            return bytesRef.bytes;
        }
        return BytesRef.deepCopyOf((BytesRef)bytesRef).bytes;
    }

    public static ByteBuffer[] toByteBuffers(BytesReference reference) {
        BytesRefIterator byteRefIterator = reference.iterator();
        try {
            BytesRef r;
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            while ((r = byteRefIterator.next()) != null) {
                buffers.add(ByteBuffer.wrap(r.bytes, r.offset, r.length));
            }
            return buffers.toArray(new ByteBuffer[buffers.size()]);
        }
        catch (IOException e) {
            throw new AssertionError("won't happen", e);
        }
    }

    public static BytesReference fromByteBuffers(ByteBuffer[] buffers) {
        int bufferCount = buffers.length;
        if (bufferCount == 0) {
            return BytesArray.EMPTY;
        }
        if (bufferCount == 1) {
            return new ByteBufferReference(buffers[0]);
        }
        BytesReference[] references = new ByteBufferReference[bufferCount];
        for (int i = 0; i < bufferCount; ++i) {
            references[i] = new ByteBufferReference(buffers[i]);
        }
        return new CompositeBytesReference(references);
    }

    @Override
    public int compareTo(BytesReference other) {
        return BytesReference.compareIterators(this, other, BytesRef::compareTo);
    }

    private static int compareIterators(BytesReference a, BytesReference b, ToIntBiFunction<BytesRef, BytesRef> f) {
        try {
            long lengthToCompare = Math.min(a.length(), b.length());
            BytesRefIterator aIter = a.iterator();
            BytesRefIterator bIter = b.iterator();
            BytesRef aRef = aIter.next();
            BytesRef bRef = bIter.next();
            if (aRef != null && bRef != null) {
                aRef = aRef.clone();
                bRef = bRef.clone();
                if (aRef.length == a.length() && bRef.length == b.length()) {
                    return f.applyAsInt(aRef, bRef);
                }
                int i = 0;
                while ((long)i < lengthToCompare) {
                    int length;
                    if (aRef.length == 0) {
                        aRef = aIter.next().clone();
                    }
                    if (bRef.length == 0) {
                        bRef = bIter.next().clone();
                    }
                    int aLength = aRef.length;
                    int bLength = bRef.length;
                    aRef.length = bRef.length = (length = Math.min(aLength, bLength));
                    int diff = f.applyAsInt(aRef, bRef);
                    aRef.length = aLength;
                    bRef.length = bLength;
                    if (diff != 0) {
                        return diff;
                    }
                    BytesReference.advance(aRef, length);
                    BytesReference.advance(bRef, length);
                    i += length;
                }
            }
            return a.length() - b.length();
        }
        catch (IOException ex) {
            throw new AssertionError("can not happen", ex);
        }
    }

    private static void advance(BytesRef ref, int length) {
        assert (ref.length >= length) : " ref.length: " + ref.length + " length: " + length;
        assert (ref.offset + length < ref.bytes.length || ref.offset + length == ref.bytes.length && ref.length - length == 0) : "offset: " + ref.offset + " ref.bytes.length: " + ref.bytes.length + " length: " + length + " ref.length: " + ref.length;
        ref.length -= length;
        ref.offset += length;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        BytesRef bytes = this.toBytesRef();
        return builder.value(bytes.bytes, bytes.offset, bytes.length);
    }

    private static final class MarkSupportingStreamInputWrapper
    extends StreamInput {
        private final BytesReference reference;
        private BytesReferenceStreamInput input;
        private int mark = 0;

        private MarkSupportingStreamInputWrapper(BytesReference reference) throws IOException {
            this.reference = reference;
            this.input = new BytesReferenceStreamInput(reference.iterator(), reference.length());
        }

        @Override
        public byte readByte() throws IOException {
            return this.input.readByte();
        }

        @Override
        public void readBytes(byte[] b, int offset, int len) throws IOException {
            this.input.readBytes(b, offset, len);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.input.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }

        @Override
        public int read() throws IOException {
            return this.input.read();
        }

        @Override
        public int available() throws IOException {
            return this.input.available();
        }

        @Override
        protected void ensureCanReadBytes(int length) throws EOFException {
            this.input.ensureCanReadBytes(length);
        }

        @Override
        public void reset() throws IOException {
            this.input = new BytesReferenceStreamInput(this.reference.iterator(), this.reference.length());
            this.input.skip(this.mark);
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readLimit) {
            this.mark = this.input.getOffset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.input.skip(n);
        }
    }
}

