/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.coordination.CoordinationMetaData;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;

public class Reconfigurator {
    private static final Logger logger = LogManager.getLogger(Reconfigurator.class);
    public static final Setting<Boolean> CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION = Setting.boolSetting("cluster.auto_shrink_voting_configuration", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile boolean autoShrinkVotingConfiguration;

    public Reconfigurator(Settings settings, ClusterSettings clusterSettings) {
        this.autoShrinkVotingConfiguration = CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION, this::setAutoShrinkVotingConfiguration);
    }

    public void setAutoShrinkVotingConfiguration(boolean autoShrinkVotingConfiguration) {
        this.autoShrinkVotingConfiguration = autoShrinkVotingConfiguration;
    }

    private static int roundDownToOdd(int size) {
        return size - (size % 2 == 0 ? 1 : 0);
    }

    public String toString() {
        return "Reconfigurator{autoShrinkVotingConfiguration=" + this.autoShrinkVotingConfiguration + '}';
    }

    public CoordinationMetaData.VotingConfiguration reconfigure(Set<DiscoveryNode> liveNodes, Set<String> retiredNodeIds, DiscoveryNode currentMaster, CoordinationMetaData.VotingConfiguration currentConfig) {
        Set<Object> nonRetiredInConfigLiveMasterIds;
        TreeSet<String> nonRetiredInConfigLiveNotMasterIds;
        assert (liveNodes.stream().noneMatch(Coordinator::isZen1Node)) : liveNodes;
        assert (liveNodes.contains(currentMaster)) : "liveNodes = " + liveNodes + " master = " + currentMaster;
        logger.trace("{} reconfiguring {} based on liveNodes={}, retiredNodeIds={}, currentMaster={}", (Object)this, (Object)currentConfig, (Object)liveNodes, (Object)retiredNodeIds, (Object)currentMaster);
        Set<String> liveNodeIds = liveNodes.stream().filter(DiscoveryNode::isMasterNode).map(DiscoveryNode::getId).collect(Collectors.toSet());
        TreeSet<String> liveInConfigIds = new TreeSet<String>(currentConfig.getNodeIds());
        liveInConfigIds.retainAll(liveNodeIds);
        SortedSet<String> inConfigNotLiveIds = Sets.sortedDifference(currentConfig.getNodeIds(), liveInConfigIds);
        TreeSet<String> nonRetiredInConfigNotLiveIds = new TreeSet<String>((Collection<String>)inConfigNotLiveIds);
        nonRetiredInConfigNotLiveIds.removeAll(retiredNodeIds);
        TreeSet<String> nonRetiredInConfigLiveIds = new TreeSet<String>((Collection<String>)liveInConfigIds);
        nonRetiredInConfigLiveIds.removeAll(retiredNodeIds);
        if (nonRetiredInConfigLiveIds.contains(currentMaster.getId())) {
            nonRetiredInConfigLiveNotMasterIds = new TreeSet<String>((Collection<String>)nonRetiredInConfigLiveIds);
            nonRetiredInConfigLiveNotMasterIds.remove(currentMaster.getId());
            nonRetiredInConfigLiveMasterIds = Collections.singleton(currentMaster.getId());
        } else {
            nonRetiredInConfigLiveNotMasterIds = nonRetiredInConfigLiveIds;
            nonRetiredInConfigLiveMasterIds = Collections.emptySet();
        }
        SortedSet<String> nonRetiredLiveNotInConfigIds = Sets.sortedDifference(liveNodeIds, currentConfig.getNodeIds());
        nonRetiredLiveNotInConfigIds.removeAll(retiredNodeIds);
        int nonRetiredLiveNodeCount = nonRetiredInConfigLiveIds.size() + nonRetiredLiveNotInConfigIds.size();
        int nonRetiredConfigSize = nonRetiredInConfigLiveIds.size() + nonRetiredInConfigNotLiveIds.size();
        int targetSize = this.autoShrinkVotingConfiguration ? (nonRetiredLiveNodeCount >= 3 ? Reconfigurator.roundDownToOdd(nonRetiredLiveNodeCount) : (nonRetiredConfigSize < 3 ? 1 : 3)) : Math.max(Reconfigurator.roundDownToOdd(nonRetiredLiveNodeCount), nonRetiredConfigSize);
        CoordinationMetaData.VotingConfiguration newConfig = new CoordinationMetaData.VotingConfiguration(Stream.of(nonRetiredInConfigLiveMasterIds, nonRetiredInConfigLiveNotMasterIds, nonRetiredLiveNotInConfigIds, nonRetiredInConfigNotLiveIds).flatMap(Collection::stream).limit(targetSize).collect(Collectors.toSet()));
        if (newConfig.hasQuorum(liveNodeIds)) {
            return newConfig;
        }
        return currentConfig;
    }
}

