/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.analyze.DetailAnalyzeResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class AnalyzeResponse
extends ActionResponse
implements Iterable<AnalyzeToken>,
ToXContentObject {
    private DetailAnalyzeResponse detail;
    private List<AnalyzeToken> tokens;
    private static final ConstructingObjectParser<AnalyzeResponse, Void> PARSER = new ConstructingObjectParser("analyze_response", true, args -> new AnalyzeResponse((List)args[0], (DetailAnalyzeResponse)args[1]));

    AnalyzeResponse() {
    }

    public AnalyzeResponse(List<AnalyzeToken> tokens, DetailAnalyzeResponse detail) {
        this.tokens = tokens;
        this.detail = detail;
    }

    public List<AnalyzeToken> getTokens() {
        return this.tokens;
    }

    public DetailAnalyzeResponse detail() {
        return this.detail;
    }

    @Override
    public Iterator<AnalyzeToken> iterator() {
        return this.tokens.iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.tokens != null) {
            builder.startArray("tokens");
            for (AnalyzeToken token : this.tokens) {
                token.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.detail != null) {
            builder.startObject("detail");
            this.detail.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static AnalyzeResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.tokens = new ArrayList<AnalyzeToken>(size);
        for (int i = 0; i < size; ++i) {
            this.tokens.add(AnalyzeToken.readAnalyzeToken(in));
        }
        if (this.tokens.size() == 0) {
            this.tokens = null;
        }
        this.detail = in.readOptionalStreamable(DetailAnalyzeResponse::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.tokens != null) {
            out.writeVInt(this.tokens.size());
            for (AnalyzeToken token : this.tokens) {
                token.writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
        out.writeOptionalStreamable(this.detail);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyzeResponse that = (AnalyzeResponse)o;
        return Objects.equals(this.detail, that.detail) && Objects.equals(this.tokens, that.tokens);
    }

    public int hashCode() {
        return Objects.hash(this.detail, this.tokens);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AnalyzeToken.fromXContent(p), new ParseField("tokens", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DetailAnalyzeResponse.PARSER, new ParseField("detail", new String[0]));
    }

    static final class Fields {
        static final String TOKENS = "tokens";
        static final String TOKEN = "token";
        static final String START_OFFSET = "start_offset";
        static final String END_OFFSET = "end_offset";
        static final String TYPE = "type";
        static final String POSITION = "position";
        static final String POSITION_LENGTH = "positionLength";
        static final String DETAIL = "detail";

        Fields() {
        }
    }

    public static class AnalyzeToken
    implements Streamable,
    ToXContentObject {
        private String term;
        private int startOffset;
        private int endOffset;
        private int position;
        private int positionLength = 1;
        private Map<String, Object> attributes;
        private String type;

        AnalyzeToken() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnalyzeToken that = (AnalyzeToken)o;
            return this.startOffset == that.startOffset && this.endOffset == that.endOffset && this.position == that.position && this.positionLength == that.positionLength && Objects.equals(this.term, that.term) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.term, this.startOffset, this.endOffset, this.position, this.positionLength, this.attributes, this.type);
        }

        public AnalyzeToken(String term, int position, int startOffset, int endOffset, int positionLength, String type, Map<String, Object> attributes) {
            this.term = term;
            this.position = position;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.positionLength = positionLength;
            this.type = type;
            this.attributes = attributes;
        }

        public String getTerm() {
            return this.term;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getPosition() {
            return this.position;
        }

        public int getPositionLength() {
            return this.positionLength;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("token", this.term);
            builder.field("start_offset", this.startOffset);
            builder.field("end_offset", this.endOffset);
            builder.field("type", this.type);
            builder.field("position", this.position);
            if (this.positionLength > 1) {
                builder.field("positionLength", this.positionLength);
            }
            if (this.attributes != null && !this.attributes.isEmpty()) {
                TreeMap<String, Object> sortedAttributes = new TreeMap<String, Object>(this.attributes);
                for (Map.Entry entity : sortedAttributes.entrySet()) {
                    builder.field((String)entity.getKey(), entity.getValue());
                }
            }
            builder.endObject();
            return builder;
        }

        public static AnalyzeToken readAnalyzeToken(StreamInput in) throws IOException {
            AnalyzeToken analyzeToken = new AnalyzeToken();
            analyzeToken.readFrom(in);
            return analyzeToken;
        }

        public static AnalyzeToken fromXContent(XContentParser parser) throws IOException {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
            String field = null;
            String term = "";
            int position = -1;
            int startOffset = -1;
            int endOffset = -1;
            int positionLength = 1;
            String type = "";
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            XContentParser.Token t = parser.nextToken();
            while (t != XContentParser.Token.END_OBJECT) {
                if (t == XContentParser.Token.FIELD_NAME) {
                    field = parser.currentName();
                } else if ("token".equals(field)) {
                    term = parser.text();
                } else if ("position".equals(field)) {
                    position = parser.intValue();
                } else if ("start_offset".equals(field)) {
                    startOffset = parser.intValue();
                } else if ("end_offset".equals(field)) {
                    endOffset = parser.intValue();
                } else if ("positionLength".equals(field)) {
                    positionLength = parser.intValue();
                } else if ("type".equals(field)) {
                    type = parser.text();
                } else if (t == XContentParser.Token.VALUE_STRING) {
                    attributes.put(field, parser.text());
                } else if (t == XContentParser.Token.VALUE_NUMBER) {
                    attributes.put(field, parser.numberValue());
                } else if (t == XContentParser.Token.VALUE_BOOLEAN) {
                    attributes.put(field, parser.booleanValue());
                } else if (t == XContentParser.Token.START_OBJECT) {
                    attributes.put(field, parser.map());
                } else if (t == XContentParser.Token.START_ARRAY) {
                    attributes.put(field, parser.list());
                }
                t = parser.nextToken();
            }
            return new AnalyzeToken(term, position, startOffset, endOffset, positionLength, type, attributes);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.term = in.readString();
            this.startOffset = in.readInt();
            this.endOffset = in.readInt();
            this.position = in.readVInt();
            Integer len = in.readOptionalVInt();
            this.positionLength = len != null ? len : 1;
            this.type = in.readOptionalString();
            this.attributes = in.readMap();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.term);
            out.writeInt(this.startOffset);
            out.writeInt(this.endOffset);
            out.writeVInt(this.position);
            out.writeOptionalVInt(this.positionLength > 1 ? Integer.valueOf(this.positionLength) : null);
            out.writeOptionalString(this.type);
            out.writeMapWithConsistentOrder(this.attributes);
        }
    }
}

