/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TaskGroup;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;

public class ListTasksResponse
extends BaseTasksResponse
implements ToXContentObject {
    private static final String TASKS = "tasks";
    private final List<TaskInfo> tasks;
    private Map<String, List<TaskInfo>> perNodeTasks;
    private List<TaskGroup> groups;
    private static final ConstructingObjectParser<ListTasksResponse, Void> PARSER = ListTasksResponse.setupParser("list_tasks_response", ListTasksResponse::new);

    public ListTasksResponse(List<TaskInfo> tasks, List<TaskOperationFailure> taskFailures, List<? extends ElasticsearchException> nodeFailures) {
        super(taskFailures, nodeFailures);
        this.tasks = tasks == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<TaskInfo>(tasks));
    }

    public ListTasksResponse(StreamInput in) throws IOException {
        super(in);
        this.tasks = Collections.unmodifiableList(in.readList(TaskInfo::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.tasks);
    }

    protected static <T> ConstructingObjectParser<T, Void> setupParser(String name, TriFunction<List<TaskInfo>, List<TaskOperationFailure>, List<ElasticsearchException>, T> ctor) {
        ConstructingObjectParser<Object, Object> parser = new ConstructingObjectParser<Object, Object>(name, true, constructingObjects -> {
            int i = 0;
            List tasks = (List)constructingObjects[i++];
            List tasksFailures = (List)constructingObjects[i++];
            List nodeFailures = (List)constructingObjects[i];
            return ctor.apply(tasks, tasksFailures, nodeFailures);
        });
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), TaskInfo.PARSER, new ParseField(TASKS, new String[0]));
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TaskOperationFailure.fromXContent(p), new ParseField("task_failures", new String[0]));
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), new ParseField("node_failures", new String[0]));
        return parser;
    }

    public Map<String, List<TaskInfo>> getPerNodeTasks() {
        if (this.perNodeTasks == null) {
            this.perNodeTasks = this.tasks.stream().collect(Collectors.groupingBy(t -> t.getTaskId().getNodeId()));
        }
        return this.perNodeTasks;
    }

    public List<TaskGroup> getTaskGroups() {
        if (this.groups == null) {
            this.buildTaskGroups();
        }
        return this.groups;
    }

    private void buildTaskGroups() {
        HashMap<TaskId, TaskGroup.Builder> taskGroups = new HashMap<TaskId, TaskGroup.Builder>();
        ArrayList<TaskGroup.Builder> topLevelTasks = new ArrayList<TaskGroup.Builder>();
        for (TaskInfo taskInfo : this.tasks) {
            taskGroups.put(taskInfo.getTaskId(), TaskGroup.builder(taskInfo));
        }
        for (TaskGroup.Builder taskGroup : taskGroups.values()) {
            TaskId parentTaskId = taskGroup.getTaskInfo().getParentTaskId();
            if (parentTaskId.isSet()) {
                TaskGroup.Builder parentTask = (TaskGroup.Builder)taskGroups.get(parentTaskId);
                if (parentTask != null) {
                    parentTask.addGroup(taskGroup);
                    continue;
                }
                topLevelTasks.add(taskGroup);
                continue;
            }
            topLevelTasks.add(taskGroup);
        }
        this.groups = Collections.unmodifiableList(topLevelTasks.stream().map(TaskGroup.Builder::build).collect(Collectors.toList()));
    }

    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    public XContentBuilder toXContentGroupedByNode(XContentBuilder builder, ToXContent.Params params, DiscoveryNodes discoveryNodes) throws IOException {
        this.toXContentCommon(builder, params);
        builder.startObject("nodes");
        for (Map.Entry<String, List<TaskInfo>> entry : this.getPerNodeTasks().entrySet()) {
            DiscoveryNode node = discoveryNodes.get(entry.getKey());
            builder.startObject(entry.getKey());
            if (node != null) {
                builder.field("name", node.getName());
                builder.field("transport_address", node.getAddress().toString());
                builder.field("host", node.getHostName());
                builder.field("ip", node.getAddress());
                builder.startArray("roles");
                for (DiscoveryNode.Role role : node.getRoles()) {
                    builder.value(role.getRoleName());
                }
                builder.endArray();
                if (!node.getAttributes().isEmpty()) {
                    builder.startObject("attributes");
                    for (Map.Entry entry2 : node.getAttributes().entrySet()) {
                        builder.field((String)entry2.getKey(), (String)entry2.getValue());
                    }
                    builder.endObject();
                }
            }
            builder.startObject(TASKS);
            for (TaskInfo taskInfo : entry.getValue()) {
                builder.startObject(taskInfo.getTaskId().toString());
                taskInfo.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentGroupedByParents(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContentCommon(builder, params);
        builder.startObject(TASKS);
        for (TaskGroup group : this.getTaskGroups()) {
            builder.field(group.getTaskInfo().getTaskId().toString());
            group.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentGroupedByNone(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContentCommon(builder, params);
        builder.startArray(TASKS);
        for (TaskInfo taskInfo : this.getTasks()) {
            builder.startObject();
            taskInfo.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentGroupedByNone(builder, params);
        builder.endObject();
        return builder;
    }

    public static ListTasksResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

