/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.indexlifecycle.action.MoveToStepAction;
import org.elasticsearch.xpack.indexlifecycle.IndexLifecycleService;

public class TransportMoveToStepAction
extends TransportMasterNodeAction<MoveToStepAction.Request, MoveToStepAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportMoveToStepAction.class);
    IndexLifecycleService indexLifecycleService;

    @Inject
    public TransportMoveToStepAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexLifecycleService indexLifecycleService) {
        super("cluster:admin/ilm/_move/post", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, MoveToStepAction.Request::new);
        this.indexLifecycleService = indexLifecycleService;
    }

    protected String executor() {
        return "same";
    }

    protected MoveToStepAction.Response newResponse() {
        return new MoveToStepAction.Response();
    }

    protected void masterOperation(final MoveToStepAction.Request request, ClusterState state, ActionListener<MoveToStepAction.Response> listener) {
        final IndexMetaData indexMetaData = state.metaData().index(request.getIndex());
        if (indexMetaData == null) {
            listener.onFailure((Exception)new IllegalArgumentException("index [" + request.getIndex() + "] does not exist"));
            return;
        }
        this.clusterService.submitStateUpdateTask("index[" + request.getIndex() + "]-move-to-step", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<MoveToStepAction.Response>((AckedRequest)request, listener){

            public ClusterState execute(ClusterState currentState) {
                return TransportMoveToStepAction.this.indexLifecycleService.moveClusterStateToStep(currentState, request.getIndex(), request.getCurrentStepKey(), request.getNextStepKey());
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                IndexMetaData newIndexMetaData = newState.metaData().index(indexMetaData.getIndex());
                if (newIndexMetaData == null) {
                    logger.debug("index [" + indexMetaData.getIndex() + "] has been deleted after moving to step [" + request.getNextStepKey() + "], skipping async action check");
                    return;
                }
                TransportMoveToStepAction.this.indexLifecycleService.maybeRunAsyncAction(newState, newIndexMetaData, request.getNextStepKey());
            }

            protected MoveToStepAction.Response newResponse(boolean acknowledged) {
                return new MoveToStepAction.Response(acknowledged);
            }
        });
    }

    protected ClusterBlockException checkBlock(MoveToStepAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

