/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.trigger.Trigger;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.TriggerWatchStats;

public class TriggerService {
    private final GroupedConsumer consumer = new GroupedConsumer();
    private final Map<String, TriggerEngine> engines;
    private final Map<String, TriggerWatchStats> perWatchStats = new ConcurrentHashMap<String, TriggerWatchStats>();

    public TriggerService(Set<TriggerEngine> engines) {
        HashMap<String, TriggerEngine> builder = new HashMap<String, TriggerEngine>();
        for (TriggerEngine engine : engines) {
            builder.put(engine.type(), engine);
            engine.register(this.consumer);
        }
        this.engines = Collections.unmodifiableMap(builder);
    }

    public synchronized void start(Collection<Watch> watches) {
        for (TriggerEngine engine : this.engines.values()) {
            engine.start(watches);
        }
        watches.forEach(this::addToStats);
    }

    public synchronized void stop() {
        for (TriggerEngine engine : this.engines.values()) {
            engine.stop();
        }
        this.perWatchStats.clear();
    }

    public synchronized void pauseExecution() {
        this.engines.values().forEach(TriggerEngine::pauseExecution);
        this.perWatchStats.clear();
    }

    private void addToStats(Watch watch) {
        TriggerWatchStats watchStats = TriggerWatchStats.create(watch);
        this.perWatchStats.put(watch.id(), watchStats);
    }

    public Counters stats() {
        Counters counters = new Counters(new String[0]);
        int watchCount = this.perWatchStats.size();
        counters.inc("count.active", (long)watchCount);
        counters.inc("count.total", (long)watchCount);
        counters.inc("watch.trigger._all.active", (long)watchCount);
        counters.inc("watch.trigger._all.total", (long)watchCount);
        counters.inc("watch.input._all.total", (long)watchCount);
        counters.inc("watch.input._all.active", (long)watchCount);
        this.perWatchStats.values().forEach(stats -> {
            if (stats.metadata) {
                counters.inc("watch.metadata.active");
                counters.inc("watch.metadata.total");
            }
            counters.inc("watch.trigger." + stats.triggerType + ".total");
            counters.inc("watch.trigger." + stats.triggerType + ".active");
            if (!Strings.isNullOrEmpty((String)stats.scheduleType)) {
                counters.inc("watch.trigger.schedule." + stats.scheduleType + ".total");
                counters.inc("watch.trigger.schedule." + stats.scheduleType + ".active");
                counters.inc("watch.trigger.schedule._all.total");
                counters.inc("watch.trigger.schedule._all.active");
            }
            counters.inc("watch.input." + stats.inputType + ".active");
            counters.inc("watch.input." + stats.inputType + ".total");
            counters.inc("watch.condition." + stats.conditionType + ".active");
            counters.inc("watch.condition." + stats.conditionType + ".total");
            counters.inc("watch.condition._all.total");
            counters.inc("watch.condition._all.active");
            if (!Strings.isNullOrEmpty((String)stats.transformType)) {
                counters.inc("watch.transform." + stats.transformType + ".active");
                counters.inc("watch.transform." + stats.transformType + ".total");
                counters.inc("watch.transform._all.active");
                counters.inc("watch.transform._all.total");
            }
            for (TriggerWatchStats.ActionStats action : stats.actions) {
                counters.inc("watch.action." + action.actionType + ".active");
                counters.inc("watch.action." + action.actionType + ".total");
                counters.inc("watch.action._all.active");
                counters.inc("watch.action._all.total");
                if (!Strings.isNullOrEmpty((String)action.conditionType)) {
                    counters.inc("watch.action.condition." + action.conditionType + ".active");
                    counters.inc("watch.action.condition." + action.conditionType + ".total");
                    counters.inc("watch.action.condition._all.active");
                    counters.inc("watch.action.condition._all.total");
                }
                if (Strings.isNullOrEmpty((String)action.transformType)) continue;
                counters.inc("watch.action.transform." + action.transformType + ".active");
                counters.inc("watch.action.transform." + action.transformType + ".total");
                counters.inc("watch.action.transform._all.active");
                counters.inc("watch.action.transform._all.total");
            }
        });
        return counters;
    }

    public void add(Watch watch) {
        this.engines.get(watch.trigger().type()).add(watch);
        this.addToStats(watch);
    }

    public boolean remove(String jobName) {
        this.perWatchStats.remove(jobName);
        for (TriggerEngine engine : this.engines.values()) {
            if (!engine.remove(jobName)) continue;
            return true;
        }
        return false;
    }

    public void register(Consumer<Iterable<TriggerEvent>> consumer) {
        this.consumer.add(consumer);
    }

    public TriggerEvent simulateEvent(String type, String jobId, Map<String, Object> data) {
        TriggerEngine engine = this.engines.get(type);
        if (engine == null) {
            throw Exceptions.illegalArgument((String)"could not simulate trigger event. unknown trigger type [{}]", (Object[])new Object[]{type});
        }
        return engine.simulateEvent(jobId, data, this);
    }

    public Trigger parseTrigger(String jobName, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        assert (token == XContentParser.Token.START_OBJECT);
        token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ElasticsearchParseException("could not parse trigger for [{}]. expected trigger type string field, but found [{}]", new Object[]{jobName, token});
        }
        String type = parser.currentName();
        token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. expected trigger an object as the trigger body, but found [{}]", new Object[]{type, jobName, token});
        }
        Trigger trigger = this.parseTrigger(jobName, type, parser);
        token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. expected [END_OBJECT] token, but found [{}]", new Object[]{type, jobName, token});
        }
        return trigger;
    }

    public Trigger parseTrigger(String jobName, String type, XContentParser parser) throws IOException {
        TriggerEngine engine = this.engines.get(type);
        if (engine == null) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. unknown trigger type [{}]", new Object[]{type, jobName, type});
        }
        return engine.parseTrigger(jobName, parser);
    }

    public TriggerEvent parseTriggerEvent(String watchId, String context, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        assert (token == XContentParser.Token.START_OBJECT);
        token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ElasticsearchParseException("could not parse trigger event for [{}] for watch [{}]. expected trigger type string field, but found [{}]", new Object[]{context, watchId, token});
        }
        String type = parser.currentName();
        token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger event for [{}] for watch [{}]. expected trigger an object as the trigger body, but found [{}]", new Object[]{context, watchId, token});
        }
        TriggerEvent trigger = this.parseTriggerEvent(watchId, context, type, parser);
        token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. expected [END_OBJECT] token, but found [{}]", new Object[]{type, context, token});
        }
        return trigger;
    }

    public TriggerEvent parseTriggerEvent(String watchId, String context, String type, XContentParser parser) throws IOException {
        TriggerEngine engine = this.engines.get(type);
        if (engine == null) {
            throw new ElasticsearchParseException("Unknown trigger type [{}]", new Object[]{type});
        }
        return engine.parseTriggerEvent(this, watchId, context, parser);
    }

    public long count() {
        return this.perWatchStats.size();
    }

    static class GroupedConsumer
    implements Consumer<Iterable<TriggerEvent>> {
        private List<Consumer<Iterable<TriggerEvent>>> consumers = new CopyOnWriteArrayList<Consumer<Iterable<TriggerEvent>>>();

        GroupedConsumer() {
        }

        public void add(Consumer<Iterable<TriggerEvent>> consumer) {
            this.consumers.add(consumer);
        }

        @Override
        public void accept(Iterable<TriggerEvent> events) {
            this.consumers.forEach(c -> c.accept(events));
        }
    }
}

