/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.indexlifecycle.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.indexlifecycle.LifecyclePolicy;
import org.elasticsearch.xpack.core.indexlifecycle.LifecyclePolicyUtils;
import org.elasticsearch.xpack.core.indexlifecycle.action.PutLifecycleAction;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class WatcherIndexTemplateRegistry
implements ClusterStateListener {
    public static final TemplateConfig TEMPLATE_CONFIG_TRIGGERED_WATCHES = new TemplateConfig(".triggered_watches", "triggered-watches");
    public static final TemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY = new TemplateConfig(".watch-history-9", "watch-history");
    public static final TemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM = new TemplateConfig(".watch-history-no-ilm-9", "watch-history-no-ilm");
    public static final TemplateConfig TEMPLATE_CONFIG_WATCHES = new TemplateConfig(".watches", "watches");
    public static final TemplateConfig[] TEMPLATE_CONFIGS = new TemplateConfig[]{TEMPLATE_CONFIG_TRIGGERED_WATCHES, TEMPLATE_CONFIG_WATCH_HISTORY, TEMPLATE_CONFIG_WATCHES};
    public static final TemplateConfig[] TEMPLATE_CONFIGS_NO_ILM = new TemplateConfig[]{TEMPLATE_CONFIG_TRIGGERED_WATCHES, TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM, TEMPLATE_CONFIG_WATCHES};
    public static final PolicyConfig POLICY_WATCH_HISTORY = new PolicyConfig("watch-history-ilm-policy", "/watch-history-ilm-policy.json");
    private static final Logger logger = LogManager.getLogger(WatcherIndexTemplateRegistry.class);
    private final Settings nodeSettings;
    private final Client client;
    private final ThreadPool threadPool;
    private final NamedXContentRegistry xContentRegistry;
    private final ConcurrentMap<String, AtomicBoolean> templateCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();
    private final AtomicBoolean historyPolicyCreationInProgress = new AtomicBoolean();

    public WatcherIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        this.nodeSettings = nodeSettings;
        this.client = client;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        clusterService.addListener((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNode masterNode = event.state().getNodes().getMasterNode();
        if (masterNode == null) {
            return;
        }
        DiscoveryNode localNode = event.state().getNodes().getLocalNode();
        boolean localNodeVersionAfterMaster = localNode.getVersion().after(masterNode.getVersion());
        if (event.localNodeMaster() || localNodeVersionAfterMaster) {
            this.addTemplatesIfMissing(state);
            this.addIndexLifecyclePolicyIfMissing(state);
        }
    }

    private void addTemplatesIfMissing(ClusterState state) {
        TemplateConfig[] indexTemplates;
        boolean ilmSupported = (Boolean)XPackSettings.INDEX_LIFECYCLE_ENABLED.get(this.nodeSettings);
        for (TemplateConfig template : indexTemplates = ilmSupported ? TEMPLATE_CONFIGS : TEMPLATE_CONFIGS_NO_ILM) {
            String templateName = template.getTemplateName();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (!creationCheck.compareAndSet(false, true)) continue;
            if (!state.metaData().getTemplates().containsKey((Object)templateName)) {
                logger.debug("adding index template [{}], because it doesn't exist", (Object)templateName);
                this.putTemplate(template, creationCheck);
                continue;
            }
            creationCheck.set(false);
            logger.trace("not adding index template [{}], because it already exists", (Object)templateName);
        }
    }

    private void putTemplate(TemplateConfig config, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            final String templateName = config.getTemplateName();
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateName).source(config.load(), XContentType.JSON);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("Error adding watcher template [{}], request was not acknowledged", (Object)templateName);
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    logger.error((Message)new ParameterizedMessage("Error adding watcher template [{}]", (Object)templateName), (Throwable)e);
                }
            }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putTemplate(arg_0, arg_1));
        });
    }

    LifecyclePolicy loadWatcherHistoryPolicy() {
        return LifecyclePolicyUtils.loadPolicy((String)POLICY_WATCH_HISTORY.policyName, (String)POLICY_WATCH_HISTORY.fileName, (NamedXContentRegistry)this.xContentRegistry);
    }

    private void addIndexLifecyclePolicyIfMissing(ClusterState state) {
        boolean ilmSupported = (Boolean)XPackSettings.INDEX_LIFECYCLE_ENABLED.get(this.nodeSettings);
        if (ilmSupported && this.historyPolicyCreationInProgress.compareAndSet(false, true)) {
            boolean needsUpdating;
            LifecyclePolicy policyOnDisk = this.loadWatcherHistoryPolicy();
            Optional<IndexLifecycleMetadata> maybeMeta = Optional.ofNullable((IndexLifecycleMetadata)state.metaData().custom("index_lifecycle"));
            boolean bl = needsUpdating = !maybeMeta.flatMap(ilmMeta -> Optional.ofNullable((LifecyclePolicy)ilmMeta.getPolicies().get(policyOnDisk.getName()))).isPresent();
            if (needsUpdating) {
                this.putPolicy(policyOnDisk, this.historyPolicyCreationInProgress);
            } else {
                this.historyPolicyCreationInProgress.set(false);
            }
        }
    }

    private void putPolicy(final LifecyclePolicy policy, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            PutLifecycleAction.Request request = new PutLifecycleAction.Request(policy);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)request, (ActionListener)new ActionListener<PutLifecycleAction.Response>(){

                public void onResponse(PutLifecycleAction.Response response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding watcher index lifecycle policy [{}], request was not acknowledged", (Object)policy.getName());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    logger.error((Message)new ParameterizedMessage("error adding watcher index lifecycle policy [{}]", (Object)policy.getName()), (Throwable)e);
                }
            }, (req, listener) -> new XPackClient(this.client).ilmClient().putLifecyclePolicy(req, listener));
        });
    }

    public static boolean validate(ClusterState state) {
        return state.getMetaData().getTemplates().containsKey((Object)".watch-history-9") && state.getMetaData().getTemplates().containsKey((Object)".triggered_watches") && state.getMetaData().getTemplates().containsKey((Object)".watches");
    }

    public static class PolicyConfig {
        private final String policyName;
        private String fileName;

        PolicyConfig(String templateName, String fileName) {
            this.policyName = templateName;
            this.fileName = fileName;
        }
    }

    public static class TemplateConfig {
        private final String templateName;
        private String fileName;

        TemplateConfig(String templateName, String fileName) {
            this.templateName = templateName;
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public byte[] load() {
            String template = TemplateUtils.loadTemplate((String)("/" + this.fileName + ".json"), (String)"9", (String)Pattern.quote("${xpack.watcher.template.version}"));
            assert (template != null && template.length() > 0);
            return template.getBytes(StandardCharsets.UTF_8);
        }
    }
}

