/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.slack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.notification.NotificationService;
import org.elasticsearch.xpack.watcher.notification.slack.SlackAccount;

public class SlackService
extends NotificationService<SlackAccount> {
    private static final Setting<String> SETTING_DEFAULT_ACCOUNT = Setting.simpleString((String)"xpack.notification.slack.default_account", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Setting.AffixSetting<SecureString> SETTING_URL_SECURE = Setting.affixKeySetting((String)"xpack.notification.slack.account.", (String)"secure_url", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<Settings> SETTING_DEFAULTS = Setting.affixKeySetting((String)"xpack.notification.slack.account.", (String)"message_defaults", key -> Setting.groupSetting((String)(key + "."), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Logger logger = LogManager.getLogger(SlackService.class);
    private final HttpClient httpClient;

    public SlackService(Settings settings, HttpClient httpClient, ClusterSettings clusterSettings) {
        super("slack", settings, clusterSettings, SlackService.getDynamicSettings(), SlackService.getSecureSettings());
        this.httpClient = httpClient;
        clusterSettings.addSettingsUpdateConsumer(SETTING_DEFAULT_ACCOUNT, s -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_DEFAULTS, (s, o) -> {}, (s, o) -> {});
        this.reload(settings);
    }

    @Override
    protected SlackAccount createAccount(String name, Settings accountSettings) {
        return new SlackAccount(name, accountSettings, this.httpClient, logger);
    }

    private static List<Setting<?>> getDynamicSettings() {
        return Arrays.asList(SETTING_DEFAULT_ACCOUNT, SETTING_DEFAULTS);
    }

    private static List<Setting<?>> getSecureSettings() {
        return Arrays.asList(SETTING_URL_SECURE);
    }

    public static List<Setting<?>> getSettings() {
        ArrayList allSettings = new ArrayList(SlackService.getDynamicSettings());
        allSettings.addAll(SlackService.getSecureSettings());
        return allSettings;
    }
}

