/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.jira;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.watcher.common.http.BasicAuth;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.common.http.HttpMethod;
import org.elasticsearch.xpack.watcher.common.http.HttpProxy;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.common.http.Scheme;
import org.elasticsearch.xpack.watcher.notification.jira.JiraIssue;

public class JiraAccount {
    public static final String DEFAULT_PATH = "/rest/api/2/issue";
    static final String ISSUE_DEFAULTS_SETTING = "issue_defaults";
    static final String ALLOW_HTTP_SETTING = "allow_http";
    public static final Setting<SecureString> SECURE_USER_SETTING = SecureSetting.secureString((String)"secure_user", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> SECURE_PASSWORD_SETTING = SecureSetting.secureString((String)"secure_password", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> SECURE_URL_SETTING = SecureSetting.secureString((String)"secure_url", null, (Setting.Property[])new Setting.Property[0]);
    private final HttpClient httpClient;
    private final String name;
    private final String user;
    private final String password;
    private final URI url;
    private final Map<String, Object> issueDefaults;

    public JiraAccount(String name, Settings settings, HttpClient httpClient) {
        this.httpClient = httpClient;
        this.name = name;
        String url = JiraAccount.getSetting(name, settings, SECURE_URL_SETTING);
        try {
            URI uri = new URI(url);
            Scheme protocol = Scheme.parse(uri.getScheme());
            if (protocol == Scheme.HTTP && !Booleans.isTrue((String)settings.get(ALLOW_HTTP_SETTING))) {
                throw new SettingsException("invalid jira [" + name + "] account settings. unsecure scheme [" + (Object)((Object)protocol) + "]");
            }
            this.url = uri;
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new SettingsException("invalid jira [" + name + "] account settings. invalid [" + SECURE_URL_SETTING.getKey() + "] setting", (Throwable)e);
        }
        this.user = JiraAccount.getSetting(name, settings, SECURE_USER_SETTING);
        this.password = JiraAccount.getSetting(name, settings, SECURE_PASSWORD_SETTING);
        try (XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());){
            builder.startObject();
            settings.getAsSettings(ISSUE_DEFAULTS_SETTING).toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            try (StreamInput stream = BytesReference.bytes((XContentBuilder)builder).streamInput();
                 XContentParser parser = XContentType.JSON.xContent().createParser(new NamedXContentRegistry(Collections.emptyList()), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                this.issueDefaults = Collections.unmodifiableMap(parser.map());
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static String getSetting(String accountName, Settings settings, Setting<SecureString> secureSetting) {
        SecureString secureString = (SecureString)secureSetting.get(settings);
        if (secureString == null || secureString.length() < 1) {
            throw JiraAccount.requiredSettingException(accountName, secureSetting.getKey());
        }
        return secureString.toString();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getDefaults() {
        return this.issueDefaults;
    }

    public JiraIssue createIssue(Map<String, Object> fields, HttpProxy proxy) throws IOException {
        HttpRequest request = HttpRequest.builder(this.url.getHost(), this.url.getPort()).scheme(Scheme.parse(this.url.getScheme())).method(HttpMethod.POST).path(this.url.getPath().isEmpty() || this.url.getPath().equals("/") ? DEFAULT_PATH : this.url.getPath()).jsonBody((builder, params) -> builder.field("fields", fields)).auth(new BasicAuth(this.user, this.password.toCharArray())).proxy(proxy).build();
        HttpResponse response = this.httpClient.execute(request);
        return JiraIssue.responded(this.name, fields, request, response);
    }

    private static SettingsException requiredSettingException(String account, String setting) {
        return new SettingsException("invalid jira [" + account + "] account settings. missing required [" + setting + "] setting");
    }
}

