/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;

public class IndexDeprecationChecks {
    private static final Set<String> TYPES_THAT_DONT_COUNT;

    private static void fieldLevelMappingIssue(IndexMetaData indexMetaData, BiConsumer<MappingMetaData, Map<String, Object>> checker) {
        for (ObjectCursor mappingMetaData : indexMetaData.getMappings().values()) {
            Map sourceAsMap = ((MappingMetaData)mappingMetaData.value).sourceAsMap();
            checker.accept((MappingMetaData)mappingMetaData.value, sourceAsMap);
        }
    }

    static List<String> findInPropertiesRecursively(String type, Map<String, Object> parentMap, Function<Map<?, ?>, Boolean> predicate) {
        ArrayList<String> issues = new ArrayList<String>();
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return issues;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (predicate.apply(valueMap).booleanValue()) {
                issues.add("[type: " + type + ", field: " + entry.getKey() + "]");
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (predicate.apply(multifieldValueMap).booleanValue()) {
                        issues.add("[type: " + type + ", field: " + entry.getKey() + ", multifield: " + multifieldEntry.getKey() + "]");
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, multifieldValueMap, predicate));
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, valueMap, predicate));
        }
        return issues;
    }

    static DeprecationIssue oldIndicesCheck(IndexMetaData indexMetaData) {
        Version createdWith = indexMetaData.getCreationVersion();
        if (createdWith.before(Version.V_7_0_0)) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Index created before 7.0", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html", "This index was created using version: " + createdWith);
        }
        return null;
    }

    static DeprecationIssue tooManyFieldsCheck(IndexMetaData indexMetaData) {
        if (indexMetaData.getSettings().get(IndexSettings.DEFAULT_FIELD_SETTING.getKey()) == null) {
            AtomicInteger fieldCount = new AtomicInteger(0);
            IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> fieldCount.addAndGet(IndexDeprecationChecks.countFieldsRecursively(mappingMetaData.type(), sourceAsMap)));
            if (fieldCount.get() > 1024) {
                return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Number of fields exceeds automatic field expansion limit", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_limiting_the_number_of_auto_expanded_fields", "This index has [" + fieldCount.get() + "] fields, which exceeds the automatic field expansion limit of 1024 and does not have [" + IndexSettings.DEFAULT_FIELD_SETTING.getKey() + "] set, which may cause queries which use automatic field expansion, such as query_string, simple_query_string, and multi_match to fail if fields are not explicitly specified in the query.");
            }
        }
        return null;
    }

    static int countFieldsRecursively(String type, Map<String, Object> parentMap) {
        int fields = 0;
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return fields;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (valueMap.containsKey("type") && !(valueMap.get("type").equals("object") && !valueMap.containsKey("properties")) && !TYPES_THAT_DONT_COUNT.contains(valueMap.get("type"))) {
                ++fields;
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (multifieldValueMap.containsKey("type") && !TYPES_THAT_DONT_COUNT.contains(valueMap.get("type"))) {
                        ++fields;
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    fields += IndexDeprecationChecks.countFieldsRecursively(type, multifieldValueMap);
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            fields += IndexDeprecationChecks.countFieldsRecursively(type, valueMap);
        }
        return fields;
    }

    static {
        HashSet<String> typesThatDontCount = new HashSet<String>();
        typesThatDontCount.add("binary");
        typesThatDontCount.add("geo_point");
        typesThatDontCount.add("geo_shape");
        TYPES_THAT_DONT_COUNT = Collections.unmodifiableSet(typesThatDontCount);
    }
}

