/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.IndexDeprecationChecks;

public class ClusterDeprecationChecks {
    private static final Logger logger = LogManager.getLogger(ClusterDeprecationChecks.class);

    static DeprecationIssue checkUserAgentPipelines(ClusterState state) {
        List pipelines = IngestService.getPipelines((ClusterState)state, (String[])new String[0]);
        List pipelinesWithDeprecatedEcsConfig = pipelines.stream().filter(Objects::nonNull).filter(pipeline -> {
            Map pipelineConfig = pipeline.getConfigAsMap();
            List processors = (List)pipelineConfig.get("processors");
            return processors.stream().filter(Objects::nonNull).filter(processor -> processor.containsKey("user_agent")).map(processor -> (Map)processor.get("user_agent")).anyMatch(processorConfig -> processorConfig.containsKey("ecs"));
        }).map(PipelineConfiguration::getId).sorted().collect(Collectors.toList());
        if (!pipelinesWithDeprecatedEcsConfig.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "User-Agent ingest plugin will always use ECS-formatted output", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html#ingest-user-agent-ecs-always", "Ingest pipelines " + pipelinesWithDeprecatedEcsConfig + " uses the [ecs] option which needs to be removed to work in 8.0");
        }
        return null;
    }

    static DeprecationIssue checkTemplatesWithTooManyFields(ClusterState state) {
        Integer maxClauseCount = (Integer)SearchModule.INDICES_MAX_CLAUSE_COUNT_SETTING.get(state.getMetaData().settings());
        ArrayList templatesOverLimit = new ArrayList();
        state.getMetaData().getTemplates().forEach(templateCursor -> {
            AtomicInteger maxFields = new AtomicInteger(0);
            String templateName = (String)templateCursor.key;
            boolean defaultFieldSet = ((IndexTemplateMetaData)templateCursor.value).settings().get(IndexSettings.DEFAULT_FIELD_SETTING.getKey()) != null;
            ((IndexTemplateMetaData)templateCursor.value).getMappings().forEach(mappingCursor -> {
                MappingMetaData mappingMetaData = new MappingMetaData((CompressedXContent)mappingCursor.value);
                if (mappingMetaData != null && !defaultFieldSet) {
                    maxFields.set(IndexDeprecationChecks.countFieldsRecursively(mappingMetaData.type(), mappingMetaData.sourceAsMap()));
                }
                if (maxFields.get() > maxClauseCount) {
                    templatesOverLimit.add(templateName);
                }
            });
        });
        if (!templatesOverLimit.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Fields in index template exceed automatic field expansion limit", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_limiting_the_number_of_auto_expanded_fields", "Index templates " + templatesOverLimit + " have a number of fields which exceeds the automatic field expansion limit of [" + maxClauseCount + "] and does not have [" + IndexSettings.DEFAULT_FIELD_SETTING.getKey() + "] set, which may cause queries which use automatic field expansion, such as query_string, simple_query_string, and multi_match to fail if fields are not explicitly specified in the query.");
        }
        return null;
    }
}

