/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.MultiMatchQueryPredicate;
import org.elasticsearch.xpack.sql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.sql.tree.Source;

public class MultiMatchQuery
extends LeafQuery {
    private static final Map<String, BiConsumer<MultiMatchQueryBuilder, String>> BUILDER_APPLIERS;
    private final String query;
    private final Map<String, Float> fields;
    private final Map<String, String> options;
    private final MultiMatchQueryPredicate predicate;

    public MultiMatchQuery(Source source, String query, Map<String, Float> fields, MultiMatchQueryPredicate predicate) {
        super(source);
        this.query = query;
        this.fields = fields;
        this.predicate = predicate;
        this.options = predicate.optionMap();
    }

    @Override
    public QueryBuilder asBuilder() {
        MultiMatchQueryBuilder queryBuilder = QueryBuilders.multiMatchQuery((Object)this.query, (String[])new String[0]);
        queryBuilder.fields(this.fields);
        queryBuilder.analyzer(this.predicate.analyzer());
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal multi_match option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, (String)v);
        });
        return queryBuilder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.query, this.fields, this.predicate);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiMatchQuery other = (MultiMatchQuery)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.fields, other.fields) && Objects.equals(this.predicate, other.predicate);
    }

    @Override
    protected String innerToString() {
        return this.fields + ":" + this.query;
    }

    static {
        HashMap<String, BiConsumer<MultiMatchQueryBuilder, String>> appliers = new HashMap<String, BiConsumer<MultiMatchQueryBuilder, String>>(14);
        appliers.put("slop", (qb, s) -> qb.slop(Integer.valueOf(s).intValue()));
        appliers.put("analyzer", (qb, s) -> qb.analyzer(s));
        appliers.put("auto_generate_synonyms_phrase_query", (qb, s) -> qb.autoGenerateSynonymsPhraseQuery(Booleans.parseBoolean((String)s)));
        appliers.put("cutoff_frequency", (qb, s) -> qb.cutoffFrequency(Float.valueOf(s)));
        appliers.put("fuzziness", (qb, s) -> qb.fuzziness((Object)Fuzziness.build((Object)s)));
        appliers.put("fuzzy_rewrite", (qb, s) -> qb.fuzzyRewrite(s));
        appliers.put("fuzzy_transpositions", (qb, s) -> qb.fuzzyTranspositions(Booleans.parseBoolean((String)s)));
        appliers.put("lenient", (qb, s) -> qb.lenient(Booleans.parseBoolean((String)s)));
        appliers.put("max_expansions", (qb, s) -> qb.maxExpansions(Integer.valueOf(s).intValue()));
        appliers.put("minimum_should_match", (qb, s) -> qb.minimumShouldMatch(s));
        appliers.put("operator", (qb, s) -> qb.operator(Operator.fromString((String)s)));
        appliers.put("prefix_length", (qb, s) -> qb.prefixLength(Integer.valueOf(s).intValue()));
        appliers.put("tie_breaker", (qb, s) -> qb.tieBreaker(Float.valueOf(s)));
        appliers.put("type", (qb, s) -> qb.type(s));
        BUILDER_APPLIERS = Collections.unmodifiableMap(appliers);
    }
}

