/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.xpack.sql.querydsl.query.Query;
import org.elasticsearch.xpack.sql.tree.Source;

public class BoolQuery
extends Query {
    private final boolean isAnd;
    private final Query left;
    private final Query right;

    public BoolQuery(Source source, boolean isAnd, Query left, Query right) {
        super(source);
        if (left == null) {
            throw new IllegalArgumentException("left is required");
        }
        if (right == null) {
            throw new IllegalArgumentException("right is required");
        }
        this.isAnd = isAnd;
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean containsNestedField(String path, String field) {
        return this.left.containsNestedField(path, field) || this.right.containsNestedField(path, field);
    }

    @Override
    public Query addNestedField(String path, String field, String format, boolean hasDocValues) {
        Query rewrittenLeft = this.left.addNestedField(path, field, format, hasDocValues);
        Query rewrittenRight = this.right.addNestedField(path, field, format, hasDocValues);
        if (rewrittenLeft == this.left && rewrittenRight == this.right) {
            return this;
        }
        return new BoolQuery(this.source(), this.isAnd, rewrittenLeft, rewrittenRight);
    }

    @Override
    public void enrichNestedSort(NestedSortBuilder sort) {
        this.left.enrichNestedSort(sort);
        this.right.enrichNestedSort(sort);
    }

    @Override
    public QueryBuilder asBuilder() {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (this.isAnd) {
            boolQuery.must(this.left.asBuilder());
            boolQuery.must(this.right.asBuilder());
        } else {
            boolQuery.should(this.left.asBuilder());
            boolQuery.should(this.right.asBuilder());
        }
        return boolQuery;
    }

    public boolean isAnd() {
        return this.isAnd;
    }

    public Query left() {
        return this.left;
    }

    public Query right() {
        return this.right;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isAnd, this.left, this.right);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BoolQuery other = (BoolQuery)obj;
        return this.isAnd == other.isAnd && this.left.equals(other.left) && this.right.equals(other.right);
    }

    @Override
    protected String innerToString() {
        return this.left + (this.isAnd ? " AND " : " OR ") + this.right;
    }
}

