/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.Collection;
import java.util.stream.Collectors;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.sql.ClientSqlException;
import org.elasticsearch.xpack.sql.planner.Verifier;
import org.elasticsearch.xpack.sql.tree.Location;

public class PlanningException
extends ClientSqlException {
    public PlanningException(String message, Object ... args) {
        super(message, args);
    }

    public PlanningException(Collection<Verifier.Failure> sources) {
        super(PlanningException.extractMessage(sources), new Object[0]);
    }

    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    private static String extractMessage(Collection<Verifier.Failure> failures) {
        return failures.stream().map(f -> {
            Location l = f.source().source().source();
            return "line " + l.getLineNumber() + ":" + l.getColumnNumber() + ": " + f.message();
        }).collect(Collectors.joining("\n", "Found " + failures.size() + " problem(s)\n", ""));
    }
}

