/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.AttributeSet;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public abstract class Attribute
extends NamedExpression {
    private final String qualifier;
    private final Nullability nullability;

    public Attribute(Source source, String name, String qualifier, ExpressionId id) {
        this(source, name, qualifier, Nullability.TRUE, id);
    }

    public Attribute(Source source, String name, String qualifier, Nullability nullability, ExpressionId id) {
        this(source, name, qualifier, nullability, id, false);
    }

    public Attribute(Source source, String name, String qualifier, Nullability nullability, ExpressionId id, boolean synthetic) {
        super(source, name, Collections.emptyList(), id, synthetic);
        this.qualifier = qualifier;
        this.nullability = nullability;
    }

    @Override
    public final Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    @Override
    public ScriptTemplate asScript() {
        throw new SqlIllegalArgumentException("Encountered a bug - an attribute should never be scripted");
    }

    public String qualifier() {
        return this.qualifier;
    }

    public String qualifiedName() {
        return this.qualifier == null ? this.name() : this.qualifier + "." + this.name();
    }

    @Override
    public Nullability nullable() {
        return this.nullability;
    }

    @Override
    public AttributeSet references() {
        return new AttributeSet(this);
    }

    public Attribute withLocation(Source source) {
        return Objects.equals(this.source(), source) ? this : this.clone(source, this.name(), this.qualifier(), this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withQualifier(String qualifier) {
        return Objects.equals(this.qualifier(), qualifier) ? this : this.clone(this.source(), this.name(), qualifier, this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withNullability(Nullability nullability) {
        return Objects.equals((Object)this.nullable(), (Object)nullability) ? this : this.clone(this.source(), this.name(), this.qualifier(), nullability, this.id(), this.synthetic());
    }

    protected abstract Attribute clone(Source var1, String var2, String var3, Nullability var4, ExpressionId var5, boolean var6);

    @Override
    public Attribute toAttribute() {
        return this;
    }

    @Override
    public int semanticHash() {
        return this.id().hashCode();
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return null;
    }

    @Override
    public boolean semanticEquals(Expression other) {
        return other instanceof Attribute ? this.id().equals(((Attribute)other).id()) : false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.qualifier, this.nullability});
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Attribute other = (Attribute)obj;
            return Objects.equals(this.qualifier, other.qualifier) && Objects.equals((Object)this.nullability, (Object)other.nullability);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.name() + "{" + this.label() + "}#" + this.id();
    }

    protected abstract String label();
}

