/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.PlanExecutor;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggregationCursor;
import org.elasticsearch.xpack.sql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.sql.execution.search.PagingListRowSet;
import org.elasticsearch.xpack.sql.execution.search.ResultRowSet;
import org.elasticsearch.xpack.sql.execution.search.SchemaCompositeAggsRowSet;
import org.elasticsearch.xpack.sql.execution.search.SchemaSearchHitRowSet;
import org.elasticsearch.xpack.sql.execution.search.SourceGenerator;
import org.elasticsearch.xpack.sql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.sql.execution.search.extractor.CompositeKeyExtractor;
import org.elasticsearch.xpack.sql.execution.search.extractor.ComputingExtractor;
import org.elasticsearch.xpack.sql.execution.search.extractor.ConstantExtractor;
import org.elasticsearch.xpack.sql.execution.search.extractor.FieldHitExtractor;
import org.elasticsearch.xpack.sql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.sql.execution.search.extractor.MetricAggExtractor;
import org.elasticsearch.xpack.sql.execution.search.extractor.TopHitsAggExtractor;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.AggExtractorInput;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.AggPathInput;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.HitExtractorInput;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.ReferenceInput;
import org.elasticsearch.xpack.sql.planner.PlanningException;
import org.elasticsearch.xpack.sql.querydsl.container.ComputedRef;
import org.elasticsearch.xpack.sql.querydsl.container.GlobalCountRef;
import org.elasticsearch.xpack.sql.querydsl.container.GroupByRef;
import org.elasticsearch.xpack.sql.querydsl.container.MetricAggRef;
import org.elasticsearch.xpack.sql.querydsl.container.QueryContainer;
import org.elasticsearch.xpack.sql.querydsl.container.ScriptFieldRef;
import org.elasticsearch.xpack.sql.querydsl.container.SearchHitFieldRef;
import org.elasticsearch.xpack.sql.querydsl.container.TopHitsAggRef;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.RowSet;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.type.Schema;
import org.elasticsearch.xpack.sql.util.StringUtils;

public class Querier {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final PlanExecutor planExecutor;
    private final Configuration cfg;
    private final TimeValue keepAlive;
    private final TimeValue timeout;
    private final int size;
    private final Client client;
    @Nullable
    private final QueryBuilder filter;

    public Querier(SqlSession sqlSession) {
        this.planExecutor = sqlSession.planExecutor();
        this.client = sqlSession.client();
        this.cfg = sqlSession.configuration();
        this.keepAlive = this.cfg.requestTimeout();
        this.timeout = this.cfg.pageTimeout();
        this.filter = this.cfg.filter();
        this.size = this.cfg.pageSize();
    }

    public void query(List<Attribute> output, QueryContainer query, String index, ActionListener<SchemaRowSet> listener) {
        SearchSourceBuilder sourceBuilder = SourceGenerator.sourceBuilder(query, this.filter, this.size);
        if (this.timeout.getSeconds() > 0L) {
            sourceBuilder.timeout(this.timeout);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("About to execute query {} on {}", (Object)StringUtils.toString(sourceBuilder), (Object)index);
        }
        SearchRequest search = Querier.prepareRequest(this.client, sourceBuilder, this.timeout, Strings.commaDelimitedListToStringArray((String)index));
        List<Tuple<Integer, Comparator>> sortingColumns = query.sortingColumns();
        listener = sortingColumns.isEmpty() ? listener : new LocalAggregationSorterListener(listener, sortingColumns, query.limit());
        BaseActionListener l = null;
        if (query.isAggsOnly()) {
            l = query.aggs().useImplicitGroupBy() ? new ImplicitGroupActionListener(listener, this.client, this.cfg, output, query, search) : new CompositeActionListener(listener, this.client, this.cfg, output, query, search);
        } else {
            search.scroll(this.keepAlive);
            l = new ScrollActionListener(listener, this.client, this.cfg, output, query);
        }
        this.client.search(search, (ActionListener)l);
    }

    public static SearchRequest prepareRequest(Client client, SearchSourceBuilder source, TimeValue timeout, String ... indices) {
        SearchRequest search = (SearchRequest)client.prepareSearch(indices).setTrackTotalHits(true).setAllowPartialSearchResults(false).setSource(source).setTimeout(timeout).request();
        return search;
    }

    static abstract class BaseActionListener
    implements ActionListener<SearchResponse> {
        final ActionListener<SchemaRowSet> listener;
        final Client client;
        final Configuration cfg;
        final TimeValue keepAlive;
        final Schema schema;

        BaseActionListener(ActionListener<SchemaRowSet> listener, Client client, Configuration cfg, List<Attribute> output) {
            this.listener = listener;
            this.client = client;
            this.cfg = cfg;
            this.keepAlive = cfg.requestTimeout();
            this.schema = Rows.schema(output);
        }

        public void onResponse(SearchResponse response) {
            try {
                Object[] failure = response.getShardFailures();
                if (!CollectionUtils.isEmpty((Object[])failure)) {
                    this.cleanup(response, (Exception)((Object)new SqlIllegalArgumentException(failure[0].reason(), failure[0].getCause())));
                } else {
                    this.handleResponse(response, (ActionListener<SchemaRowSet>)ActionListener.wrap(arg_0 -> this.listener.onResponse(arg_0), e -> this.cleanup(response, (Exception)e)));
                }
            }
            catch (Exception ex) {
                this.cleanup(response, ex);
            }
        }

        protected abstract void handleResponse(SearchResponse var1, ActionListener<SchemaRowSet> var2);

        protected final void cleanup(SearchResponse response, Exception ex) {
            if (response != null && response.getScrollId() != null) {
                this.client.prepareClearScroll().addScrollId(response.getScrollId()).execute(ActionListener.wrap(r -> this.listener.onFailure(ex), e -> {
                    ex.addSuppressed((Throwable)e);
                    this.listener.onFailure(ex);
                }));
            } else {
                this.listener.onFailure(ex);
            }
        }

        protected final void clear(String scrollId, ActionListener<Boolean> listener) {
            if (scrollId != null) {
                this.client.prepareClearScroll().addScrollId(scrollId).execute(ActionListener.wrap(clearScrollResponse -> listener.onResponse((Object)clearScrollResponse.isSucceeded()), arg_0 -> listener.onFailure(arg_0)));
            } else {
                listener.onResponse((Object)false);
            }
        }

        public final void onFailure(Exception ex) {
            this.listener.onFailure(ex);
        }
    }

    static class ScrollActionListener
    extends BaseActionListener {
        private final QueryContainer query;
        private final BitSet mask;
        private final boolean multiValueFieldLeniency;

        ScrollActionListener(ActionListener<SchemaRowSet> listener, Client client, Configuration cfg, List<Attribute> output, QueryContainer query) {
            super(listener, client, cfg, output);
            this.query = query;
            this.mask = query.columnMask(output);
            this.multiValueFieldLeniency = cfg.multiValueFieldLeniency();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void handleResponse(SearchResponse response, ActionListener<SchemaRowSet> listener) {
            SchemaSearchHitRowSet hitRowSet;
            block5: {
                ArrayList<HitExtractor> exts;
                SearchHit[] hits;
                block6: {
                    hits = response.getHits().getHits();
                    List<Tuple<FieldExtraction, ExpressionId>> refs = this.query.fields();
                    exts = new ArrayList<HitExtractor>(refs.size());
                    for (Tuple<FieldExtraction, ExpressionId> ref : refs) {
                        exts.add(this.createExtractor((FieldExtraction)ref.v1()));
                    }
                    if (hits.length <= 0) {
                        this.clear(response.getScrollId(), (ActionListener<Boolean>)ActionListener.wrap(succeeded -> listener.onResponse((Object)Rows.empty(this.schema)), arg_0 -> listener.onFailure(arg_0)));
                        return;
                    }
                    String scrollId = response.getScrollId();
                    hitRowSet = new SchemaSearchHitRowSet(this.schema, exts, this.mask, hits, this.query.limit(), scrollId);
                    if (scrollId == null) break block5;
                    if (Boolean.TRUE.equals(response.isTerminatedEarly()) || response.getHits().getTotalHits().value == (long)hits.length) break block6;
                    if (!hitRowSet.isLimitReached()) break block5;
                }
                this.clear(response.getScrollId(), (ActionListener<Boolean>)ActionListener.wrap(succeeded -> listener.onResponse((Object)new SchemaSearchHitRowSet(this.schema, exts, this.mask, hits, this.query.limit(), null)), arg_0 -> listener.onFailure(arg_0)));
                return;
            }
            listener.onResponse((Object)hitRowSet);
        }

        private HitExtractor createExtractor(FieldExtraction ref) {
            if (ref instanceof SearchHitFieldRef) {
                SearchHitFieldRef f = (SearchHitFieldRef)ref;
                return new FieldHitExtractor(f.name(), f.getDataType(), this.cfg.zoneId(), f.useDocValue(), f.hitName(), this.multiValueFieldLeniency);
            }
            if (ref instanceof ScriptFieldRef) {
                ScriptFieldRef f = (ScriptFieldRef)ref;
                return new FieldHitExtractor(f.name(), null, this.cfg.zoneId(), true, this.multiValueFieldLeniency);
            }
            if (ref instanceof ComputedRef) {
                Pipe proc = ((ComputedRef)ref).processor();
                LinkedHashSet hitNames = new LinkedHashSet();
                proc = proc.transformDown(l -> {
                    HitExtractor he = this.createExtractor((FieldExtraction)l.context());
                    hitNames.add(he.hitName());
                    if (hitNames.size() > 1) {
                        throw new SqlIllegalArgumentException("Multi-level nested fields [{}] not supported yet", hitNames);
                    }
                    return new HitExtractorInput(l.source(), l.expression(), he);
                }, ReferenceInput.class);
                String hitName = null;
                if (hitNames.size() == 1) {
                    hitName = (String)hitNames.iterator().next();
                }
                return new ComputingExtractor(proc.asProcessor(), hitName);
            }
            throw new SqlIllegalArgumentException("Unexpected value reference {}", ref.getClass());
        }
    }

    static abstract class BaseAggActionListener
    extends BaseActionListener {
        final QueryContainer query;
        final SearchRequest request;
        final BitSet mask;

        BaseAggActionListener(ActionListener<SchemaRowSet> listener, Client client, Configuration cfg, List<Attribute> output, QueryContainer query, SearchRequest request) {
            super(listener, client, cfg, output);
            this.query = query;
            this.request = request;
            this.mask = query.columnMask(output);
        }

        protected List<BucketExtractor> initBucketExtractors(SearchResponse response) {
            List<Tuple<FieldExtraction, ExpressionId>> refs = this.query.fields();
            ArrayList<BucketExtractor> exts = new ArrayList<BucketExtractor>(refs.size());
            ConstantExtractor totalCount = new ConstantExtractor(response.getHits().getTotalHits().value);
            for (Tuple<FieldExtraction, ExpressionId> ref : refs) {
                exts.add(this.createExtractor((FieldExtraction)ref.v1(), totalCount));
            }
            return exts;
        }

        private BucketExtractor createExtractor(FieldExtraction ref, BucketExtractor totalCount) {
            if (ref instanceof GroupByRef) {
                GroupByRef r = (GroupByRef)ref;
                return new CompositeKeyExtractor(r.key(), r.property(), this.cfg.zoneId(), r.isDateTimeBased());
            }
            if (ref instanceof MetricAggRef) {
                MetricAggRef r = (MetricAggRef)ref;
                return new MetricAggExtractor(r.name(), r.property(), r.innerKey(), this.cfg.zoneId(), r.isDateTimeBased());
            }
            if (ref instanceof TopHitsAggRef) {
                TopHitsAggRef r = (TopHitsAggRef)ref;
                return new TopHitsAggExtractor(r.name(), r.fieldDataType(), this.cfg.zoneId());
            }
            if (ref == GlobalCountRef.INSTANCE) {
                return totalCount;
            }
            if (ref instanceof ComputedRef) {
                Pipe proc = ((ComputedRef)ref).processor();
                proc = proc.transformDown(l -> {
                    BucketExtractor be = this.createExtractor((FieldExtraction)l.context(), totalCount);
                    return new AggExtractorInput(l.source(), l.expression(), l.action(), be);
                }, AggPathInput.class);
                return new ComputingExtractor(proc.asProcessor());
            }
            throw new SqlIllegalArgumentException("Unexpected value reference {}", ref.getClass());
        }
    }

    static class CompositeActionListener
    extends BaseAggActionListener {
        CompositeActionListener(ActionListener<SchemaRowSet> listener, Client client, Configuration cfg, List<Attribute> output, QueryContainer query, SearchRequest request) {
            super(listener, client, cfg, output, query, request);
        }

        @Override
        protected void handleResponse(SearchResponse response, ActionListener<SchemaRowSet> listener) {
            if (response.getAggregations().asList().size() > 0) {
                if (CompositeAggregationCursor.shouldRetryDueToEmptyPage(response)) {
                    CompositeAggregationCursor.updateCompositeAfterKey(response, this.request.source());
                    this.client.search(this.request, (ActionListener)this);
                    return;
                }
                CompositeAggregationCursor.updateCompositeAfterKey(response, this.request.source());
                byte[] nextSearch = null;
                try {
                    nextSearch = CompositeAggregationCursor.serializeQuery(this.request.source());
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                    return;
                }
                listener.onResponse((Object)new SchemaCompositeAggsRowSet(this.schema, this.initBucketExtractors(response), this.mask, response, this.query.limit(), nextSearch, this.request.indices()));
            } else {
                listener.onResponse((Object)Rows.empty(this.schema));
            }
        }
    }

    static class ImplicitGroupActionListener
    extends BaseAggActionListener {
        private static List<? extends MultiBucketsAggregation.Bucket> EMPTY_BUCKET = Collections.singletonList(new MultiBucketsAggregation.Bucket(){

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                throw new SqlIllegalArgumentException("No group-by/aggs defined");
            }

            public Object getKey() {
                throw new SqlIllegalArgumentException("No group-by/aggs defined");
            }

            public String getKeyAsString() {
                throw new SqlIllegalArgumentException("No group-by/aggs defined");
            }

            public long getDocCount() {
                throw new SqlIllegalArgumentException("No group-by/aggs defined");
            }

            public Aggregations getAggregations() {
                throw new SqlIllegalArgumentException("No group-by/aggs defined");
            }
        });

        ImplicitGroupActionListener(ActionListener<SchemaRowSet> listener, Client client, Configuration cfg, List<Attribute> output, QueryContainer query, SearchRequest request) {
            super(listener, client, cfg, output, query, request);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void handleResponse(SearchResponse response, ActionListener<SchemaRowSet> listener) {
            Aggregations aggs = response.getAggregations();
            if (aggs != null) {
                Aggregation agg = aggs.get("groupby");
                if (!(agg instanceof Filters)) throw new SqlIllegalArgumentException("Unrecognized root group found; {}", agg.getClass());
                this.handleBuckets(((Filters)agg).getBuckets(), response);
                return;
            } else {
                this.handleBuckets(EMPTY_BUCKET, response);
            }
        }

        private void handleBuckets(List<? extends MultiBucketsAggregation.Bucket> buckets, SearchResponse response) {
            if (buckets.size() == 1) {
                MultiBucketsAggregation.Bucket implicitGroup = buckets.get(0);
                List<BucketExtractor> extractors = this.initBucketExtractors(response);
                Object[] values = new Object[this.mask.cardinality()];
                int index = 0;
                int i = this.mask.nextSetBit(0);
                while (i >= 0) {
                    values[index++] = extractors.get(i).extract(implicitGroup);
                    i = this.mask.nextSetBit(i + 1);
                }
                this.listener.onResponse((Object)Rows.singleton(this.schema, values));
            } else if (buckets.isEmpty()) {
                this.listener.onResponse((Object)Rows.empty(this.schema));
            } else {
                throw new SqlIllegalArgumentException("Too many groups returned by the implicit group; expected 1, received {}", buckets.size());
            }
        }
    }

    class LocalAggregationSorterListener
    implements ActionListener<SchemaRowSet> {
        private final ActionListener<SchemaRowSet> listener;
        private final PriorityQueue<Tuple<List<?>, Integer>> data;
        private final AtomicInteger counter = new AtomicInteger();
        private volatile Schema schema;
        private static final int MAXIMUM_SIZE = 512;
        private final boolean noLimit;

        LocalAggregationSorterListener(ActionListener<SchemaRowSet> listener, final List<Tuple<Integer, Comparator>> sortingColumns, int limit) {
            this.listener = listener;
            int size = 512;
            if (limit < 0) {
                this.noLimit = true;
            } else {
                this.noLimit = false;
                if (limit > 512) {
                    throw new PlanningException("The maximum LIMIT for aggregate sorting is [{}], received [{}]", limit, 512);
                }
                size = limit;
            }
            this.data = new PriorityQueue<Tuple<List<?>, Integer>>(size){

                protected boolean lessThan(Tuple<List<?>, Integer> l, Tuple<List<?>, Integer> r) {
                    for (Tuple tuple : sortingColumns) {
                        int i = (Integer)tuple.v1();
                        Comparator comparator = (Comparator)tuple.v2();
                        Object vl = ((List)l.v1()).get(i);
                        Object vr = ((List)r.v1()).get(i);
                        if (comparator != null) {
                            int result = comparator.compare(vl, vr);
                            if (result == 0) continue;
                            return result < 0;
                        }
                        if (Objects.equals(vl, vr)) continue;
                        return ((Integer)l.v2()).compareTo((Integer)r.v2()) < 0;
                    }
                    return ((Integer)l.v2()).compareTo((Integer)r.v2()) < 0;
                }
            };
        }

        public void onResponse(SchemaRowSet schemaRowSet) {
            this.schema = schemaRowSet.schema();
            this.doResponse(schemaRowSet);
        }

        private void doResponse(RowSet rowSet) {
            if (!this.consumeRowSet(rowSet)) {
                return;
            }
            Cursor cursor = rowSet.nextPageCursor();
            if (cursor != Cursor.EMPTY) {
                Querier.this.planExecutor.nextPage(Querier.this.cfg, cursor, (ActionListener<RowSet>)ActionListener.wrap(this::doResponse, this::onFailure));
                return;
            }
            this.sendResponse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean consumeRowSet(RowSet rowSet) {
            ResultRowSet rrs = (ResultRowSet)rowSet;
            PriorityQueue<Tuple<List<?>, Integer>> priorityQueue = this.data;
            synchronized (priorityQueue) {
                boolean hasRows = rrs.hasCurrentRow();
                while (hasRows) {
                    ArrayList row = new ArrayList(rrs.columnCount());
                    rrs.forEachResultColumn(row::add);
                    if (this.data.insertWithOverflow((Object)new Tuple(row, (Object)this.counter.getAndIncrement())) != null && this.noLimit) {
                        this.onFailure((Exception)((Object)new SqlIllegalArgumentException("The default limit [{}] for aggregate sorting has been reached; please specify a LIMIT")));
                        return false;
                    }
                    hasRows = rrs.advanceRow();
                }
            }
            return true;
        }

        private void sendResponse() {
            ArrayList list = new ArrayList(this.data.size());
            Tuple pop = null;
            while ((pop = (Tuple)this.data.pop()) != null) {
                list.add((List)pop.v1());
            }
            this.listener.onResponse((Object)new PagingListRowSet(this.schema, list, this.schema.size(), Querier.this.cfg.pageSize()));
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

