/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.elasticsearch.nio.NioChannel;
import org.elasticsearch.nio.SocketChannelContext;

public class NioSocketChannel
extends NioChannel {
    private final AtomicBoolean contextSet = new AtomicBoolean(false);
    private final SocketChannel socketChannel;
    private final InetSocketAddress remoteAddress;
    private volatile InetSocketAddress localAddress;
    private SocketChannelContext context;

    public NioSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        try {
            this.remoteAddress = (InetSocketAddress)socketChannel.getRemoteAddress();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void setContext(SocketChannelContext context) {
        if (!this.contextSet.compareAndSet(false, true)) {
            throw new IllegalStateException("Context on this channel were already set. It should only be once.");
        }
        this.context = context;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (this.localAddress == null) {
            this.localAddress = (InetSocketAddress)this.socketChannel.socket().getLocalSocketAddress();
        }
        return this.localAddress;
    }

    @Override
    public SocketChannel getRawChannel() {
        return this.socketChannel;
    }

    public SocketChannelContext getContext() {
        return this.context;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void addConnectListener(BiConsumer<Void, Exception> listener) {
        this.context.addConnectListener(listener);
    }

    public String toString() {
        return "NioSocketChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.remoteAddress + '}';
    }
}

