/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.nio.ChannelContext;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.SelectionKeyUtils;
import org.elasticsearch.nio.ServerChannelContext;
import org.elasticsearch.nio.SocketChannelContext;

public class EventHandler {
    protected final Consumer<Exception> exceptionHandler;
    private final Supplier<NioSelector> selectorSupplier;

    public EventHandler(Consumer<Exception> exceptionHandler, Supplier<NioSelector> selectorSupplier) {
        this.exceptionHandler = exceptionHandler;
        this.selectorSupplier = selectorSupplier;
    }

    protected void acceptChannel(ServerChannelContext context) throws IOException {
        context.acceptChannels(this.selectorSupplier);
    }

    protected void acceptException(ServerChannelContext context, Exception exception) {
        context.handleException(exception);
    }

    protected void handleRegistration(ChannelContext<?> context) throws IOException {
        context.register();
        SelectionKey selectionKey = context.getSelectionKey();
        selectionKey.attach(context);
        if (context instanceof SocketChannelContext) {
            if (((SocketChannelContext)context).readyForFlush()) {
                SelectionKeyUtils.setConnectReadAndWriteInterested(context.getSelectionKey());
            } else {
                SelectionKeyUtils.setConnectAndReadInterested(context.getSelectionKey());
            }
        } else {
            assert (context instanceof ServerChannelContext) : "If not SocketChannelContext the context must be a ServerChannelContext";
            SelectionKeyUtils.setAcceptInterested(context.getSelectionKey());
        }
    }

    protected void registrationException(ChannelContext<?> context, Exception exception) {
        context.handleException(exception);
    }

    protected void handleConnect(SocketChannelContext context) throws IOException {
        if (context.connect()) {
            SelectionKeyUtils.removeConnectInterested(context.getSelectionKey());
        }
    }

    protected void connectException(SocketChannelContext context, Exception exception) {
        context.handleException(exception);
    }

    protected void handleRead(SocketChannelContext context) throws IOException {
        context.read();
    }

    protected void readException(SocketChannelContext context, Exception exception) {
        context.handleException(exception);
    }

    protected void handleWrite(SocketChannelContext context) throws IOException {
        context.flushChannel();
    }

    protected void writeException(SocketChannelContext context, Exception exception) {
        context.handleException(exception);
    }

    protected void taskException(Exception exception) {
        this.exceptionHandler.accept(exception);
    }

    protected void postHandling(SocketChannelContext context) {
        if (context.selectorShouldClose()) {
            this.handleClose(context);
        } else {
            SelectionKey selectionKey = context.getSelectionKey();
            boolean currentlyWriteInterested = SelectionKeyUtils.isWriteInterested(selectionKey);
            boolean pendingWrites = context.readyForFlush();
            if (!currentlyWriteInterested && pendingWrites) {
                SelectionKeyUtils.setWriteInterested(selectionKey);
            } else if (currentlyWriteInterested && !pendingWrites) {
                SelectionKeyUtils.removeWriteInterested(selectionKey);
            }
        }
    }

    protected void selectorException(IOException exception) {
        this.exceptionHandler.accept(exception);
    }

    protected void uncaughtException(Exception exception) {
        Thread thread = Thread.currentThread();
        thread.getUncaughtExceptionHandler().uncaughtException(thread, exception);
    }

    protected void handleClose(ChannelContext<?> context) {
        try {
            context.closeFromSelector();
        }
        catch (IOException e) {
            this.closeException(context, e);
        }
        assert (!context.isOpen()) : "Should always be done as we are on the selector thread";
    }

    protected void closeException(ChannelContext<?> channel, Exception exception) {
        channel.handleException(exception);
    }

    protected void genericChannelException(ChannelContext<?> channel, Exception exception) {
        channel.handleException(exception);
    }
}

