/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.execution;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapperResult;
import org.elasticsearch.xpack.core.watcher.execution.ExecutionPhase;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;

public class WatchExecutionSnapshot
implements Streamable,
ToXContentObject {
    private String watchId;
    private String watchRecordId;
    private ZonedDateTime triggeredTime;
    private ZonedDateTime executionTime;
    private ExecutionPhase phase;
    private String[] executedActions;
    private StackTraceElement[] executionStackTrace;

    public WatchExecutionSnapshot() {
    }

    public WatchExecutionSnapshot(WatchExecutionContext context, StackTraceElement[] executionStackTrace) {
        this.watchId = context.id().watchId();
        this.watchRecordId = context.id().value();
        this.triggeredTime = context.triggerEvent().triggeredTime();
        this.executionTime = context.executionTime();
        this.phase = context.executionPhase();
        if (this.phase == ExecutionPhase.ACTIONS) {
            Map<String, ActionWrapperResult> actionResults = context.actionsResults();
            this.executedActions = new String[actionResults.size()];
            int i = 0;
            for (ActionWrapperResult actionResult : actionResults.values()) {
                this.executedActions[i++] = actionResult.id();
            }
        }
        this.executionStackTrace = executionStackTrace;
    }

    public String watchId() {
        return this.watchId;
    }

    public String watchRecordId() {
        return this.watchRecordId;
    }

    public ZonedDateTime triggeredTime() {
        return this.triggeredTime;
    }

    public ZonedDateTime executionTime() {
        return this.executionTime;
    }

    public ExecutionPhase executionPhase() {
        return this.phase;
    }

    public StackTraceElement[] executionStackTrace() {
        return this.executionStackTrace;
    }

    public void readFrom(StreamInput in) throws IOException {
        this.watchId = in.readString();
        this.watchRecordId = in.readString();
        this.triggeredTime = Instant.ofEpochMilli(in.readVLong()).atZone(ZoneOffset.UTC);
        this.executionTime = Instant.ofEpochMilli(in.readVLong()).atZone(ZoneOffset.UTC);
        this.phase = ExecutionPhase.resolve(in.readString());
        int size = in.readVInt();
        this.executionStackTrace = new StackTraceElement[size];
        for (int i = 0; i < size; ++i) {
            String declaringClass = in.readString();
            String methodName = in.readString();
            String fileName = in.readOptionalString();
            int lineNumber = in.readInt();
            this.executionStackTrace[i] = new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.watchId);
        out.writeString(this.watchRecordId);
        out.writeVLong(this.triggeredTime.toInstant().toEpochMilli());
        out.writeVLong(this.executionTime.toInstant().toEpochMilli());
        out.writeString(this.phase.id());
        out.writeVInt(this.executionStackTrace.length);
        for (StackTraceElement element : this.executionStackTrace) {
            out.writeString(element.getClassName());
            out.writeString(element.getMethodName());
            out.writeOptionalString(element.getFileName());
            out.writeInt(element.getLineNumber());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("watch_id", this.watchId);
        builder.field("watch_record_id", this.watchRecordId);
        builder.timeField("triggered_time", (Object)this.triggeredTime);
        builder.timeField("execution_time", (Object)this.executionTime);
        builder.field("execution_phase", (Object)this.phase);
        if (this.executedActions != null) {
            builder.startArray("executed_actions");
            for (String executedAction : this.executedActions) {
                builder.value(executedAction);
            }
            builder.endArray();
        }
        if (params.paramAsBoolean("emit_stacktraces", false)) {
            builder.startArray("stack_trace");
            for (StackTraceElement element : this.executionStackTrace) {
                builder.value(element.toString());
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }
}

