/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.transport.SSLExceptionHelper;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;

public class SecurityNetty4Transport
extends Netty4Transport {
    private static final Logger logger = LogManager.getLogger(SecurityNetty4Transport.class);
    private final SSLService sslService;
    private final SSLConfiguration sslConfiguration;
    private final Map<String, SSLConfiguration> profileConfiguration;
    private final boolean sslEnabled;

    public SecurityNetty4Transport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, SSLService sslService) {
        super(settings, version, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService);
        this.sslService = sslService;
        this.sslEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        if (this.sslEnabled) {
            this.sslConfiguration = sslService.getSSLConfiguration(SecurityField.setting("transport.ssl."));
            Map<String, SSLConfiguration> profileConfiguration = SecurityNetty4Transport.getTransportProfileConfigurations(settings, sslService, this.sslConfiguration);
            this.profileConfiguration = Collections.unmodifiableMap(profileConfiguration);
        } else {
            this.profileConfiguration = Collections.emptyMap();
            this.sslConfiguration = null;
        }
    }

    public static Map<String, SSLConfiguration> getTransportProfileConfigurations(Settings settings, SSLService sslService, SSLConfiguration defaultConfiguration) {
        Set profileNames = settings.getGroups("transport.profiles.", true).keySet();
        HashMap<String, SSLConfiguration> profileConfiguration = new HashMap<String, SSLConfiguration>(profileNames.size() + 1);
        for (String profileName : profileNames) {
            if (profileName.equals("default")) {
                if (settings.getByPrefix("transport.profiles.default.xpack.security.ssl.").isEmpty()) continue;
                throw new IllegalArgumentException("SSL settings should not be configured for the default profile. Use the [xpack.security.transport.ssl] settings instead.");
            }
            SSLConfiguration configuration = sslService.getSSLConfiguration("transport.profiles." + profileName + "." + SecurityField.setting("ssl"));
            profileConfiguration.put(profileName, configuration);
        }
        assert (!profileConfiguration.containsKey("default"));
        profileConfiguration.put("default", defaultConfiguration);
        return profileConfiguration;
    }

    protected void doStart() {
        super.doStart();
    }

    public final ChannelHandler getServerChannelInitializer(String name) {
        if (this.sslEnabled) {
            SSLConfiguration configuration = this.profileConfiguration.get(name);
            if (configuration == null) {
                throw new IllegalStateException("unknown profile: " + name);
            }
            return this.getSslChannelInitializer(name, configuration);
        }
        return this.getNoSslChannelInitializer(name);
    }

    protected ChannelHandler getNoSslChannelInitializer(String name) {
        return super.getServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node) {
        return new SecurityClientChannelInitializer(node);
    }

    public void onException(TcpChannel channel, Exception e) {
        if (!this.lifecycle.started()) {
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isNotSslRecordException(e)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Message)new ParameterizedMessage("received plaintext traffic on an encrypted channel, closing connection {}", (Object)channel), (Throwable)e);
            } else {
                logger.warn("received plaintext traffic on an encrypted channel, closing connection {}", (Object)channel);
            }
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException(e)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Message)new ParameterizedMessage("connection {} closed during ssl handshake", (Object)channel), (Throwable)e);
            } else {
                logger.warn("connection {} closed during handshake", (Object)channel);
            }
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isReceivedCertificateUnknownException(e)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Message)new ParameterizedMessage("client did not trust server's certificate, closing connection {}", (Object)channel), (Throwable)e);
            } else {
                logger.warn("client did not trust this server's certificate, closing connection {}", (Object)channel);
            }
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else {
            super.onException(channel, e);
        }
    }

    protected Netty4Transport.ServerChannelInitializer getSslChannelInitializer(String name, SSLConfiguration configuration) {
        return new SslChannelInitializer(name, this.sslConfiguration);
    }

    private static class ClientSslHandlerInitializer
    extends ChannelOutboundHandlerAdapter {
        private final boolean hostnameVerificationEnabled;
        private final SSLConfiguration sslConfiguration;
        private final SSLService sslService;
        private final SNIServerName serverName;

        private ClientSslHandlerInitializer(SSLConfiguration sslConfiguration, SSLService sslService, boolean hostnameVerificationEnabled, SNIServerName serverName) {
            this.sslConfiguration = sslConfiguration;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.sslService = sslService;
            this.serverName = serverName;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            SSLEngine sslEngine;
            if (this.hostnameVerificationEnabled) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                sslEngine = this.sslService.createSSLEngine(this.sslConfiguration, inetSocketAddress.getHostString(), inetSocketAddress.getPort());
            } else {
                sslEngine = this.sslService.createSSLEngine(this.sslConfiguration, null, -1);
            }
            sslEngine.setUseClientMode(true);
            if (this.serverName != null) {
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setServerNames(Collections.singletonList(this.serverName));
                sslEngine.setSSLParameters(sslParameters);
            }
            ctx.pipeline().replace((ChannelHandler)this, "ssl", (ChannelHandler)new SslHandler(sslEngine));
            super.connect(ctx, remoteAddress, localAddress, promise);
        }
    }

    private class SecurityClientChannelInitializer
    extends Netty4Transport.ClientChannelInitializer {
        private final boolean hostnameVerificationEnabled;
        private final SNIHostName serverName;

        SecurityClientChannelInitializer(DiscoveryNode node) {
            super((Netty4Transport)SecurityNetty4Transport.this);
            this.hostnameVerificationEnabled = SecurityNetty4Transport.this.sslEnabled && SecurityNetty4Transport.this.sslConfiguration.verificationMode().isHostnameVerificationEnabled();
            String configuredServerName = (String)node.getAttributes().get("server_name");
            if (configuredServerName != null) {
                try {
                    this.serverName = new SNIHostName(configuredServerName);
                }
                catch (IllegalArgumentException e) {
                    throw new ConnectTransportException(node, "invalid DiscoveryNode server_name [" + configuredServerName + "]", (Throwable)e);
                }
            } else {
                this.serverName = null;
            }
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (SecurityNetty4Transport.this.sslEnabled) {
                ch.pipeline().addFirst(new ChannelHandler[]{new ClientSslHandlerInitializer(SecurityNetty4Transport.this.sslConfiguration, SecurityNetty4Transport.this.sslService, this.hostnameVerificationEnabled, this.serverName)});
            }
        }
    }

    public class SslChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        private final SSLConfiguration configuration;

        public SslChannelInitializer(String name, SSLConfiguration configuration) {
            super((Netty4Transport)SecurityNetty4Transport.this, name);
            this.configuration = configuration;
        }

        protected void initChannel(Channel ch) throws Exception {
            SSLEngine serverEngine = SecurityNetty4Transport.this.sslService.createSSLEngine(this.configuration, null, -1);
            serverEngine.setUseClientMode(false);
            SslHandler sslHandler = new SslHandler(serverEngine);
            ch.pipeline().addFirst("sslhandler", (ChannelHandler)sslHandler);
            super.initChannel(ch);
            assert (ch.pipeline().first() == sslHandler) : "SSL handler must be first handler in pipeline";
        }
    }
}

