/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.DocumentSubsetReader;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.DocumentPermissions;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.User;

public class SecurityIndexSearcherWrapper
extends org.elasticsearch.index.shard.IndexSearcherWrapper {
    private static final Logger logger = LogManager.getLogger(SecurityIndexSearcherWrapper.class);
    private final Function<ShardId, QueryShardContext> queryShardContextProvider;
    private final BitsetFilterCache bitsetFilterCache;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final ScriptService scriptService;

    public SecurityIndexSearcherWrapper(Function<ShardId, QueryShardContext> queryShardContextProvider, BitsetFilterCache bitsetFilterCache, ThreadContext threadContext, XPackLicenseState licenseState, ScriptService scriptService) {
        this.scriptService = scriptService;
        this.queryShardContextProvider = queryShardContextProvider;
        this.bitsetFilterCache = bitsetFilterCache;
        this.threadContext = threadContext;
        this.licenseState = licenseState;
    }

    protected DirectoryReader wrap(DirectoryReader reader) {
        if (!this.licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
            return reader;
        }
        try {
            BooleanQuery filterQuery;
            IndicesAccessControl indicesAccessControl = this.getIndicesAccessControl();
            ShardId shardId = ShardUtils.extractShardId((DirectoryReader)reader);
            if (shardId == null) {
                throw new IllegalStateException(LoggerMessageFormat.format((String)"couldn't extract shardId from reader [{}]", (Object[])new Object[]{reader}));
            }
            IndicesAccessControl.IndexAccessControl permissions = indicesAccessControl.getIndexPermissions(shardId.getIndexName());
            if (permissions == null) {
                return reader;
            }
            Object wrappedReader = reader;
            DocumentPermissions documentPermissions = permissions.getDocumentPermissions();
            if (documentPermissions != null && documentPermissions.hasDocumentLevelPermissions() && (filterQuery = documentPermissions.filter(this.getUser(), this.scriptService, shardId, this.queryShardContextProvider)) != null) {
                wrappedReader = DocumentSubsetReader.wrap(wrappedReader, this.bitsetFilterCache, (Query)new ConstantScoreQuery((Query)filterQuery));
            }
            return permissions.getFieldPermissions().filter((DirectoryReader)wrappedReader);
        }
        catch (IOException e) {
            logger.error("Unable to apply field level security");
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    protected IndexSearcher wrap(IndexSearcher searcher) throws EngineException {
        if (!this.licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
            return searcher;
        }
        DirectoryReader directoryReader = (DirectoryReader)searcher.getIndexReader();
        if (directoryReader instanceof DocumentSubsetReader.DocumentSubsetDirectoryReader) {
            IndexSearcherWrapper indexSearcher = new IndexSearcherWrapper((DocumentSubsetReader.DocumentSubsetDirectoryReader)directoryReader);
            indexSearcher.setQueryCache(indexSearcher.getQueryCache());
            indexSearcher.setQueryCachingPolicy(indexSearcher.getQueryCachingPolicy());
            indexSearcher.setSimilarity(indexSearcher.getSimilarity());
            return indexSearcher;
        }
        return searcher;
    }

    static void intersectScorerAndRoleBits(Scorer scorer, SparseFixedBitSet roleBits, LeafCollector collector, Bits acceptDocs) throws IOException {
        DocIdSetIterator iterator = ConjunctionDISI.intersectIterators(Arrays.asList(new BitSetIterator((BitSet)roleBits, (long)roleBits.approximateCardinality()), scorer.iterator()));
        int docId = iterator.nextDoc();
        while (docId < Integer.MAX_VALUE) {
            if (acceptDocs == null || acceptDocs.get(docId)) {
                collector.collect(docId);
            }
            docId = iterator.nextDoc();
        }
    }

    protected IndicesAccessControl getIndicesAccessControl() {
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions");
        if (indicesAccessControl == null) {
            throw Exceptions.authorizationError("no indices permissions found", new Object[0]);
        }
        return indicesAccessControl;
    }

    protected User getUser() {
        Authentication authentication = Authentication.getAuthentication(this.threadContext);
        return authentication.getUser();
    }

    static class IndexSearcherWrapper
    extends IndexSearcher {
        IndexSearcherWrapper(DocumentSubsetReader.DocumentSubsetDirectoryReader r) {
            super((IndexReader)r);
        }

        protected void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
            for (LeafReaderContext ctx : leaves) {
                LeafCollector leafCollector;
                try {
                    leafCollector = collector.getLeafCollector(ctx);
                }
                catch (CollectionTerminatedException e) {
                    continue;
                }
                DocumentSubsetReader reader = (DocumentSubsetReader)ctx.reader();
                BitSet roleQueryBits = reader.getRoleQueryBits();
                if (roleQueryBits == null) continue;
                if (roleQueryBits instanceof SparseFixedBitSet) {
                    Scorer scorer = weight.scorer(ctx);
                    if (scorer == null) continue;
                    SparseFixedBitSet sparseFixedBitSet = (SparseFixedBitSet)roleQueryBits;
                    Bits realLiveDocs = reader.getWrappedLiveDocs();
                    try {
                        SecurityIndexSearcherWrapper.intersectScorerAndRoleBits(scorer, sparseFixedBitSet, leafCollector, realLiveDocs);
                    }
                    catch (CollectionTerminatedException collectionTerminatedException) {}
                    continue;
                }
                BulkScorer bulkScorer = weight.bulkScorer(ctx);
                if (bulkScorer == null) continue;
                Bits liveDocs = reader.getLiveDocs();
                try {
                    bulkScorer.score(leafCollector, liveDocs);
                }
                catch (CollectionTerminatedException collectionTerminatedException) {}
            }
        }
    }
}

