/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class InvalidateApiKeyRequest
extends ActionRequest {
    private final String realmName;
    private final String userName;
    private final String id;
    private final String name;

    public InvalidateApiKeyRequest() {
        this(null, null, null, null);
    }

    public InvalidateApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.realmName = in.readOptionalString();
        this.userName = in.readOptionalString();
        this.id = in.readOptionalString();
        this.name = in.readOptionalString();
    }

    public InvalidateApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String id, @Nullable String name) {
        this.realmName = realmName;
        this.userName = userName;
        this.id = id;
        this.name = name;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static InvalidateApiKeyRequest usingRealmName(String realmName) {
        return new InvalidateApiKeyRequest(realmName, null, null, null);
    }

    public static InvalidateApiKeyRequest usingUserName(String userName) {
        return new InvalidateApiKeyRequest(null, userName, null, null);
    }

    public static InvalidateApiKeyRequest usingRealmAndUserName(String realmName, String userName) {
        return new InvalidateApiKeyRequest(realmName, userName, null, null);
    }

    public static InvalidateApiKeyRequest usingApiKeyId(String id) {
        return new InvalidateApiKeyRequest(null, null, id, null);
    }

    public static InvalidateApiKeyRequest usingApiKeyName(String name) {
        return new InvalidateApiKeyRequest(null, null, null, name);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!(Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName) || Strings.hasText((String)this.id) || Strings.hasText((String)this.name))) {
            validationException = ValidateActions.addValidationError((String)"One of [api key id, api key name, username, realm name] must be specified", (ActionRequestValidationException)validationException);
        }
        if ((Strings.hasText((String)this.id) || Strings.hasText((String)this.name)) && (Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName))) {
            validationException = ValidateActions.addValidationError((String)"username or realm name must not be specified when the api key id or api key name is specified", validationException);
        }
        if (Strings.hasText((String)this.id) && Strings.hasText((String)this.name)) {
            validationException = ValidateActions.addValidationError((String)"only one of [api key id, api key name] can be specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.realmName);
        out.writeOptionalString(this.userName);
        out.writeOptionalString(this.id);
        out.writeOptionalString(this.name);
    }

    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }
}

