/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.node.Node;
import org.elasticsearch.xpack.core.security.UserSettings;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.User;

public class SecurityContext {
    private final Logger logger = LogManager.getLogger(SecurityContext.class);
    private final ThreadContext threadContext;
    private final UserSettings userSettings;
    private final String nodeName;

    public SecurityContext(Settings settings, ThreadContext threadContext) {
        this.threadContext = threadContext;
        this.userSettings = new UserSettings(threadContext);
        this.nodeName = (String)Node.NODE_NAME_SETTING.get(settings);
    }

    public User getUser() {
        Authentication authentication = this.getAuthentication();
        return authentication == null ? null : authentication.getUser();
    }

    public Authentication getAuthentication() {
        try {
            return Authentication.readFromContext(this.threadContext);
        }
        catch (IOException e) {
            this.logger.error("failed to read authentication", (Throwable)e);
            return null;
        }
    }

    public void setUser(User user, Version version) {
        Objects.requireNonNull(user);
        Authentication.RealmRef authenticatedBy = new Authentication.RealmRef("__attach", "__attach", this.nodeName);
        Authentication.RealmRef lookedUpBy = user.isRunAs() ? authenticatedBy : null;
        this.setAuthentication(new Authentication(user, authenticatedBy, lookedUpBy, version, Authentication.AuthenticationType.INTERNAL, Collections.emptyMap()));
    }

    private void setAuthentication(Authentication authentication) {
        try {
            authentication.writeToContext(this.threadContext);
        }
        catch (IOException e) {
            throw new AssertionError("how can we have a IOException with a user we set", e);
        }
    }

    public void executeAsUser(User user, Consumer<ThreadContext.StoredContext> consumer, Version version) {
        ThreadContext.StoredContext original = this.threadContext.newStoredContext(true);
        try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
            this.setUser(user, version);
            consumer.accept(original);
        }
    }

    public void executeAfterRewritingAuthentication(Consumer<ThreadContext.StoredContext> consumer, Version version) {
        ThreadContext.StoredContext original = this.threadContext.newStoredContext(true);
        Authentication authentication = Objects.requireNonNull(this.userSettings.getAuthentication());
        try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
            this.setAuthentication(new Authentication(authentication.getUser(), authentication.getAuthenticatedBy(), authentication.getLookedUpBy(), version, authentication.getAuthenticationType(), authentication.getMetadata()));
            consumer.accept(original);
        }
    }
}

