/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.rollup.RollupField;

public class StopRollupJobAction
extends Action<Response> {
    public static final StopRollupJobAction INSTANCE = new StopRollupJobAction();
    public static final String NAME = "cluster:admin/xpack/rollup/stop";
    public static final ParseField WAIT_FOR_COMPLETION = new ParseField("wait_for_completion", new String[0]);
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(30L, TimeUnit.SECONDS);

    private StopRollupJobAction() {
        super(NAME);
    }

    public Response newResponse() {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    public Writeable.Reader<Response> getResponseReader() {
        return Response::new;
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private final boolean stopped;

        public Response(boolean stopped) {
            super(Collections.emptyList(), Collections.emptyList());
            this.stopped = stopped;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.stopped = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.stopped);
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("stopped", this.stopped);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.stopped == response.stopped;
        }

        public int hashCode() {
            return Objects.hash(this.stopped);
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        protected RequestBuilder(ElasticsearchClient client, StopRollupJobAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends BaseTasksRequest<Request>
    implements ToXContent {
        private String id;
        private boolean waitForCompletion = false;
        private TimeValue timeout = null;

        public Request(String id) {
            this(id, false, null);
        }

        public Request(String id, boolean waitForCompletion, @Nullable TimeValue timeout) {
            this.id = ExceptionsHelper.requireNonNull(id, RollupField.ID.getPreferredName());
            this.timeout = timeout == null ? DEFAULT_TIMEOUT : timeout;
            this.waitForCompletion = waitForCompletion;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
                this.waitForCompletion = in.readBoolean();
                this.timeout = in.readTimeValue();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
                out.writeBoolean(this.waitForCompletion);
                out.writeTimeValue(this.timeout);
            }
        }

        public String getId() {
            return this.id;
        }

        public TimeValue timeout() {
            return this.timeout;
        }

        public boolean waitForCompletion() {
            return this.waitForCompletion;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(RollupField.ID.getPreferredName(), this.id);
            builder.field(WAIT_FOR_COMPLETION.getPreferredName(), this.waitForCompletion);
            if (this.timeout != null) {
                builder.field(TIMEOUT.getPreferredName(), (Object)this.timeout);
            }
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.waitForCompletion, this.timeout);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.id, other.id) && Objects.equals(this.waitForCompletion, other.waitForCompletion) && Objects.equals(this.timeout, other.timeout);
        }
    }
}

