/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;

public class LoggingDeprecationAccumulationHandler
implements DeprecationHandler {
    private final List<String> deprecations = new ArrayList<String>();

    public void usedDeprecatedName(String usedName, String modernName) {
        LoggingDeprecationHandler.INSTANCE.usedDeprecatedName(usedName, modernName);
        this.deprecations.add(LoggerMessageFormat.format((String)"Deprecated field [{}] used, expected [{}] instead", (Object[])new Object[]{usedName, modernName}));
    }

    public void usedDeprecatedField(String usedName, String replacedWith) {
        LoggingDeprecationHandler.INSTANCE.usedDeprecatedField(usedName, replacedWith);
        this.deprecations.add(LoggerMessageFormat.format((String)"Deprecated field [{}] used, replaced by [{}]", (Object[])new Object[]{usedName, replacedWith}));
    }

    public List<String> getDeprecations() {
        return Collections.unmodifiableList(this.deprecations);
    }
}

