/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.Index;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DelayedDataCheckConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.core.ml.job.config.Operator;
import org.elasticsearch.xpack.core.ml.job.config.RuleCondition;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshotField;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyCause;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.core.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.Influence;
import org.elasticsearch.xpack.core.ml.job.results.Influencer;
import org.elasticsearch.xpack.core.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.core.ml.job.results.ReservedFieldNames;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.notifications.AuditMessage;

public class ElasticsearchMappings {
    public static final String ENABLED = "enabled";
    public static final String ANALYZER = "analyzer";
    public static final String WHITESPACE = "whitespace";
    public static final String NESTED = "nested";
    public static final String COPY_TO = "copy_to";
    public static final String PROPERTIES = "properties";
    public static final String TYPE = "type";
    public static final String DYNAMIC = "dynamic";
    public static final String FIELDS = "fields";
    public static final String ALL_FIELD_VALUES = "all_field_values";
    public static final String ES_DOC = "_doc";
    public static final String CONFIG_TYPE = "config_type";
    public static final String BOOLEAN = "boolean";
    public static final String DATE = "date";
    public static final String DOUBLE = "double";
    public static final String INTEGER = "integer";
    public static final String KEYWORD = "keyword";
    public static final String LONG = "long";
    public static final String TEXT = "text";
    static final String RAW = "raw";
    private static final Logger logger = LogManager.getLogger(ElasticsearchMappings.class);

    private ElasticsearchMappings() {
    }

    public static XContentBuilder configMapping() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.startObject(ES_DOC);
        ElasticsearchMappings.addMetaInformation(builder);
        ElasticsearchMappings.addDefaultMapping(builder);
        builder.startObject(PROPERTIES);
        ElasticsearchMappings.addJobConfigFields(builder);
        ElasticsearchMappings.addDatafeedConfigFields(builder);
        builder.endObject().endObject().endObject();
        return builder;
    }

    public static void addJobConfigFields(XContentBuilder builder) throws IOException {
        builder.startObject(CONFIG_TYPE).field(TYPE, KEYWORD).endObject().startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Job.JOB_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Job.JOB_VERSION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Job.GROUPS.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Job.ANALYSIS_CONFIG.getPreferredName()).startObject(PROPERTIES).startObject(AnalysisConfig.BUCKET_SPAN.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnalysisConfig.CATEGORIZATION_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnalysisConfig.CATEGORIZATION_FILTERS.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnalysisConfig.CATEGORIZATION_ANALYZER.getPreferredName()).field(ENABLED, false).endObject().startObject(AnalysisConfig.LATENCY.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnalysisConfig.SUMMARY_COUNT_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnalysisConfig.DETECTORS.getPreferredName()).startObject(PROPERTIES).startObject(Detector.DETECTOR_DESCRIPTION_FIELD.getPreferredName()).field(TYPE, TEXT).endObject().startObject(Detector.FUNCTION_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Detector.FIELD_NAME_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Detector.BY_FIELD_NAME_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Detector.OVER_FIELD_NAME_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Detector.PARTITION_FIELD_NAME_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Detector.USE_NULL_FIELD.getPreferredName()).field(TYPE, BOOLEAN).endObject().startObject(Detector.EXCLUDE_FREQUENT_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Detector.CUSTOM_RULES_FIELD.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(DetectionRule.ACTIONS_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DetectionRule.SCOPE_FIELD.getPreferredName()).field(ENABLED, false).endObject().startObject(DetectionRule.CONDITIONS_FIELD.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(RuleCondition.APPLIES_TO_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Operator.OPERATOR_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(RuleCondition.VALUE_FIELD.getPreferredName()).field(TYPE, DOUBLE).endObject().endObject().endObject().endObject().endObject().startObject(Detector.DETECTOR_INDEX.getPreferredName()).field(TYPE, INTEGER).endObject().endObject().endObject().startObject(AnalysisConfig.INFLUENCERS.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnalysisConfig.MULTIVARIATE_BY_FIELDS.getPreferredName()).field(TYPE, BOOLEAN).endObject().endObject().endObject().startObject(Job.ANALYSIS_LIMITS.getPreferredName()).startObject(PROPERTIES).startObject(AnalysisLimits.MODEL_MEMORY_LIMIT.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnalysisLimits.CATEGORIZATION_EXAMPLES_LIMIT.getPreferredName()).field(TYPE, LONG).endObject().endObject().endObject().startObject(Job.CREATE_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(Job.CUSTOM_SETTINGS.getPreferredName()).field(ENABLED, false).endObject().startObject(Job.DATA_DESCRIPTION.getPreferredName()).startObject(PROPERTIES).startObject(DataDescription.FORMAT_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DataDescription.TIME_FIELD_NAME_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DataDescription.TIME_FORMAT_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DataDescription.FIELD_DELIMITER_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DataDescription.QUOTE_CHARACTER_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(Job.DESCRIPTION.getPreferredName()).field(TYPE, TEXT).endObject().startObject(Job.FINISHED_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(Job.MODEL_PLOT_CONFIG.getPreferredName()).startObject(PROPERTIES).startObject(ModelPlotConfig.ENABLED_FIELD.getPreferredName()).field(TYPE, BOOLEAN).endObject().startObject(ModelPlotConfig.TERMS_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(Job.RENORMALIZATION_WINDOW_DAYS.getPreferredName()).field(TYPE, LONG).endObject().startObject(Job.BACKGROUND_PERSIST_INTERVAL.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Job.MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName()).field(TYPE, LONG).endObject().startObject(Job.RESULTS_RETENTION_DAYS.getPreferredName()).field(TYPE, LONG).endObject().startObject(Job.MODEL_SNAPSHOT_ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Job.MODEL_SNAPSHOT_MIN_VERSION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Job.RESULTS_INDEX_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject();
    }

    public static void addDatafeedConfigFields(XContentBuilder builder) throws IOException {
        builder.startObject(DatafeedConfig.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DatafeedConfig.QUERY_DELAY.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DatafeedConfig.FREQUENCY.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DatafeedConfig.INDICES.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DatafeedConfig.QUERY.getPreferredName()).field(ENABLED, false).endObject().startObject(DatafeedConfig.SCROLL_SIZE.getPreferredName()).field(TYPE, LONG).endObject().startObject(DatafeedConfig.AGGREGATIONS.getPreferredName()).field(ENABLED, false).endObject().startObject(DatafeedConfig.SCRIPT_FIELDS.getPreferredName()).field(ENABLED, false).endObject().startObject(DatafeedConfig.CHUNKING_CONFIG.getPreferredName()).startObject(PROPERTIES).startObject(ChunkingConfig.MODE_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ChunkingConfig.TIME_SPAN_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(DatafeedConfig.DELAYED_DATA_CHECK_CONFIG.getPreferredName()).startObject(PROPERTIES).startObject(DelayedDataCheckConfig.ENABLED.getPreferredName()).field(TYPE, BOOLEAN).endObject().startObject(DelayedDataCheckConfig.CHECK_WINDOW.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(DatafeedConfig.HEADERS.getPreferredName()).field(ENABLED, false).endObject();
    }

    public static void addDefaultMapping(XContentBuilder builder) throws IOException {
        builder.startArray("dynamic_templates").startObject().startObject("strings_as_keywords").field("match", "*").startObject("mapping").field(TYPE, KEYWORD).endObject().endObject().endObject().endArray();
    }

    public static void addMetaInformation(XContentBuilder builder) throws IOException {
        builder.startObject("_meta").field("version", (ToXContent)Version.CURRENT).endObject();
    }

    public static XContentBuilder resultsMapping(String mappingType) throws IOException {
        return ElasticsearchMappings.resultsMapping(mappingType, Collections.emptyList());
    }

    public static XContentBuilder resultsMapping(String mappingType, Collection<String> extraTermFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.startObject(mappingType);
        ElasticsearchMappings.addMetaInformation(builder);
        ElasticsearchMappings.addDefaultMapping(builder);
        builder.startObject(PROPERTIES);
        builder.startObject(ALL_FIELD_VALUES).field(TYPE, TEXT).field(ANALYZER, WHITESPACE).endObject();
        builder.startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject();
        builder.startObject(Result.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject();
        ElasticsearchMappings.addResultsMapping(builder);
        ElasticsearchMappings.addCategoryDefinitionMapping(builder);
        ElasticsearchMappings.addDataCountsMapping(builder);
        ElasticsearchMappings.addModelSnapshotMapping(builder);
        ElasticsearchMappings.addTermFields(builder, extraTermFields);
        builder.endObject();
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static void addResultsMapping(XContentBuilder builder) throws IOException {
        builder.startObject(Result.RESULT_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Bucket.ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.RAW_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Bucket.INITIAL_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Result.IS_INTERIM.getPreferredName()).field(TYPE, BOOLEAN).endObject().startObject(Bucket.EVENT_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(Bucket.BUCKET_SPAN.getPreferredName()).field(TYPE, LONG).endObject().startObject(Bucket.PROCESSING_TIME_MS.getPreferredName()).field(TYPE, LONG).endObject().startObject(Bucket.SCHEDULED_EVENTS.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Bucket.BUCKET_INFLUENCERS.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Result.RESULT_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(BucketInfluencer.INFLUENCER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(BucketInfluencer.INITIAL_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.RAW_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.PROBABILITY.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Result.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject().startObject(BucketInfluencer.BUCKET_SPAN.getPreferredName()).field(TYPE, LONG).endObject().startObject(Result.IS_INTERIM.getPreferredName()).field(TYPE, BOOLEAN).endObject().endObject().endObject().startObject(ModelPlot.MODEL_FEATURE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelPlot.MODEL_LOWER.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(ModelPlot.MODEL_UPPER.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(ModelPlot.MODEL_MEDIAN.getPreferredName()).field(TYPE, DOUBLE).endObject();
        ElasticsearchMappings.addForecastFieldsToMapping(builder);
        ElasticsearchMappings.addAnomalyRecordFieldsToMapping(builder);
        ElasticsearchMappings.addInfluencerFieldsToMapping(builder);
        ElasticsearchMappings.addModelSizeStatsFieldsToMapping(builder);
    }

    public static XContentBuilder termFieldsMapping(Collection<String> termFields) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            builder.startObject(ES_DOC);
            builder.startObject(PROPERTIES);
            ElasticsearchMappings.addTermFields(builder, termFields);
            builder.endObject();
            builder.endObject();
            return builder.endObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addTermFields(XContentBuilder builder, Collection<String> termFields) throws IOException {
        for (String fieldName : termFields) {
            if (!ReservedFieldNames.isValidFieldName(fieldName)) continue;
            builder.startObject(fieldName).field(TYPE, KEYWORD).endObject();
        }
    }

    private static void addForecastFieldsToMapping(XContentBuilder builder) throws IOException {
        builder.startObject(Forecast.FORECAST_LOWER.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Forecast.FORECAST_UPPER.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Forecast.FORECAST_PREDICTION.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Forecast.FORECAST_ID.getPreferredName()).field(TYPE, KEYWORD).endObject();
        builder.startObject(ForecastRequestStats.START_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(ForecastRequestStats.END_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(ForecastRequestStats.CREATE_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(ForecastRequestStats.EXPIRY_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(ForecastRequestStats.MESSAGES.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ForecastRequestStats.PROGRESS.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(ForecastRequestStats.STATUS.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ForecastRequestStats.MEMORY_USAGE.getPreferredName()).field(TYPE, LONG).endObject();
    }

    private static void addAnomalyRecordFieldsToMapping(XContentBuilder builder) throws IOException {
        builder.startObject(Detector.DETECTOR_INDEX.getPreferredName()).field(TYPE, INTEGER).endObject().startObject(AnomalyRecord.ACTUAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.TYPICAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.PROBABILITY.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.MULTI_BUCKET_IMPACT.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.FUNCTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.FUNCTION_DESCRIPTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.BY_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.BY_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyRecord.FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.PARTITION_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyRecord.OVER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.OVER_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyRecord.RECORD_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.INITIAL_RECORD_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.CAUSES.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(AnomalyCause.ACTUAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyCause.TYPICAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyCause.PROBABILITY.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyCause.FUNCTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.FUNCTION_DESCRIPTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.BY_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.BY_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyCause.CORRELATED_BY_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyCause.FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.PARTITION_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.PARTITION_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyCause.OVER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.OVER_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().endObject().endObject().startObject(AnomalyRecord.INFLUENCERS.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(Influence.INFLUENCER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Influence.INFLUENCER_FIELD_VALUES.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().endObject().endObject();
    }

    private static void addInfluencerFieldsToMapping(XContentBuilder builder) throws IOException {
        builder.startObject(Influencer.INFLUENCER_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Influencer.INITIAL_INFLUENCER_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Influencer.INFLUENCER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Influencer.INFLUENCER_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject();
    }

    private static void addDataCountsMapping(XContentBuilder builder) throws IOException {
        builder.startObject(DataCounts.PROCESSED_RECORD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.PROCESSED_FIELD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INPUT_BYTES.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INPUT_RECORD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INPUT_FIELD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INVALID_DATE_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.MISSING_FIELD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.OUT_OF_ORDER_TIME_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.EMPTY_BUCKET_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.SPARSE_BUCKET_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.BUCKET_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.EARLIEST_RECORD_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LATEST_RECORD_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LATEST_EMPTY_BUCKET_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LATEST_SPARSE_BUCKET_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LAST_DATA_TIME.getPreferredName()).field(TYPE, DATE).endObject();
    }

    private static void addCategoryDefinitionMapping(XContentBuilder builder) throws IOException {
        builder.startObject(CategoryDefinition.CATEGORY_ID.getPreferredName()).field(TYPE, LONG).endObject().startObject(CategoryDefinition.TERMS.getPreferredName()).field(TYPE, TEXT).endObject().startObject(CategoryDefinition.REGEX.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(CategoryDefinition.MAX_MATCHING_LENGTH.getPreferredName()).field(TYPE, LONG).endObject().startObject(CategoryDefinition.EXAMPLES.getPreferredName()).field(TYPE, TEXT).endObject();
    }

    public static XContentBuilder stateMapping() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.startObject(ES_DOC);
        ElasticsearchMappings.addMetaInformation(builder);
        builder.field(ENABLED, false);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static void addModelSnapshotMapping(XContentBuilder builder) throws IOException {
        builder.startObject(ModelSnapshot.DESCRIPTION.getPreferredName()).field(TYPE, TEXT).endObject().startObject(ModelSnapshotField.SNAPSHOT_ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelSnapshot.SNAPSHOT_DOC_COUNT.getPreferredName()).field(TYPE, INTEGER).endObject().startObject(ModelSnapshot.RETAIN.getPreferredName()).field(TYPE, BOOLEAN).endObject().startObject(ModelSizeStats.RESULT_TYPE_FIELD.getPreferredName()).startObject(PROPERTIES).startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Result.RESULT_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelSizeStats.TIMESTAMP_FIELD.getPreferredName()).field(TYPE, DATE).endObject();
        ElasticsearchMappings.addModelSizeStatsFieldsToMapping(builder);
        builder.endObject();
        builder.endObject();
        builder.startObject(ModelSnapshot.QUANTILES.getPreferredName()).field(ENABLED, false).endObject().startObject(ModelSnapshot.MIN_VERSION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelSnapshot.LATEST_RECORD_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(ModelSnapshot.LATEST_RESULT_TIME.getPreferredName()).field(TYPE, DATE).endObject();
    }

    private static void addModelSizeStatsFieldsToMapping(XContentBuilder builder) throws IOException {
        builder.startObject(ModelSizeStats.MODEL_BYTES_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.TOTAL_BY_FIELD_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.TOTAL_OVER_FIELD_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.TOTAL_PARTITION_FIELD_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.BUCKET_ALLOCATION_FAILURES_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.MEMORY_STATUS_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelSizeStats.LOG_TIME_FIELD.getPreferredName()).field(TYPE, DATE).endObject();
    }

    public static XContentBuilder auditMessageMapping() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        builder.startObject(ES_DOC);
        ElasticsearchMappings.addMetaInformation(builder);
        builder.startObject(PROPERTIES).startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AuditMessage.LEVEL.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AuditMessage.MESSAGE.getPreferredName()).field(TYPE, TEXT).startObject(FIELDS).startObject(RAW).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(AuditMessage.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject().startObject(AuditMessage.NODE_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().endObject();
        return builder;
    }

    static String[] mappingRequiresUpdate(ClusterState state, String[] concreteIndices, Version minVersion) throws IOException {
        ArrayList<String> indicesToUpdate = new ArrayList<String>();
        ImmutableOpenMap currentMapping = state.metaData().findMappings(concreteIndices, new String[0], MapperPlugin.NOOP_FIELD_FILTER);
        for (String index : concreteIndices) {
            ImmutableOpenMap innerMap = (ImmutableOpenMap)currentMapping.get((Object)index);
            if (innerMap != null) {
                MappingMetaData metaData = (MappingMetaData)innerMap.valuesIt().next();
                try {
                    Map meta = (Map)metaData.sourceAsMap().get("_meta");
                    if (meta != null) {
                        String versionString = (String)meta.get("version");
                        if (versionString == null) {
                            logger.info("Version of mappings for [{}] not found, recreating", (Object)index);
                            indicesToUpdate.add(index);
                            continue;
                        }
                        Version mappingVersion = Version.fromString((String)versionString);
                        if (mappingVersion.onOrAfter(minVersion)) continue;
                        logger.info("Mappings for [{}] are outdated [{}], updating it[{}].", (Object)index, (Object)mappingVersion, (Object)Version.CURRENT);
                        indicesToUpdate.add(index);
                        continue;
                    }
                    logger.info("Version of mappings for [{}] not found, recreating", (Object)index);
                    indicesToUpdate.add(index);
                }
                catch (Exception e) {
                    logger.error((Message)new ParameterizedMessage("Failed to retrieve mapping version for [{}], recreating", (Object)index), (Throwable)e);
                    indicesToUpdate.add(index);
                }
                continue;
            }
            logger.info("No mappings found for [{}], recreating", (Object)index);
            indicesToUpdate.add(index);
        }
        return indicesToUpdate.toArray(new String[indicesToUpdate.size()]);
    }

    public static void addDocMappingIfMissing(String alias, CheckedBiFunction<String, Collection<String>, XContentBuilder, IOException> mappingSupplier, Client client, ClusterState state, ActionListener<Boolean> listener) {
        String[] indicesThatRequireAnUpdate;
        AliasOrIndex aliasOrIndex = (AliasOrIndex)state.metaData().getAliasAndIndexLookup().get(alias);
        if (aliasOrIndex == null) {
            listener.onResponse((Object)true);
            return;
        }
        String[] concreteIndices = (String[])aliasOrIndex.getIndices().stream().map(IndexMetaData::getIndex).map(Index::getName).toArray(String[]::new);
        try {
            indicesThatRequireAnUpdate = ElasticsearchMappings.mappingRequiresUpdate(state, concreteIndices, Version.CURRENT);
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
            return;
        }
        if (indicesThatRequireAnUpdate.length > 0) {
            IndexMetaData indexMetaData = state.metaData().index(indicesThatRequireAnUpdate[0]);
            String mappingType = indexMetaData.mapping().type();
            try (XContentBuilder mapping = (XContentBuilder)mappingSupplier.apply((Object)mappingType, Collections.emptyList());){
                PutMappingRequest putMappingRequest = new PutMappingRequest(indicesThatRequireAnUpdate);
                putMappingRequest.type(mappingType);
                putMappingRequest.source(mapping);
                ClientHelper.executeAsyncWithOrigin(client, "ml", PutMappingAction.INSTANCE, putMappingRequest, ActionListener.wrap(response -> {
                    if (response.isAcknowledged()) {
                        listener.onResponse((Object)true);
                    } else {
                        listener.onFailure((Exception)new ElasticsearchException("Attempt to put missing mapping in indices " + Arrays.toString(indicesThatRequireAnUpdate) + " was not acknowledged", new Object[0]));
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        } else {
            logger.trace("Mappings are up to date.");
            listener.onResponse((Object)true);
        }
    }
}

