/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;

public class PutJobAction
extends Action<Response> {
    public static final PutJobAction INSTANCE = new PutJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/put";

    private PutJobAction() {
        super(NAME);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private Job job;

        public Response(Job job) {
            this.job = job;
        }

        public Response() {
        }

        public Job getResponse() {
            return this.job;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.getVersion().before(Version.V_6_3_0)) {
                in.readBoolean();
            }
            this.job = new Job(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().before(Version.V_6_3_0)) {
                out.writeBoolean(true);
            }
            this.job.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.job.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals((Object)this.job, (Object)response.job);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.job});
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, PutJobAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private Job.Builder jobBuilder;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Job.Builder jobBuilder = (Job.Builder)Job.STRICT_PARSER.apply(parser, null);
            if (jobBuilder.getId() == null) {
                jobBuilder.setId(jobId);
            } else if (!Strings.isNullOrEmpty((String)jobId) && !jobId.equals(jobBuilder.getId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", Job.ID.getPreferredName(), jobBuilder.getId(), jobId));
            }
            return new Request(jobBuilder);
        }

        public Request(Job.Builder jobBuilder) {
            jobBuilder.validateInputFields();
            List<String> invalidJobCreationSettings = jobBuilder.invalidCreateTimeSettings();
            if (!invalidJobCreationSettings.isEmpty()) {
                throw new IllegalArgumentException(Messages.getMessage("The job is configured with fields [{0}] that are illegal to set at job creation", String.join((CharSequence)",", invalidJobCreationSettings)));
            }
            this.jobBuilder = jobBuilder;
        }

        public Request() {
        }

        public Job.Builder getJobBuilder() {
            return this.jobBuilder;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobBuilder = new Job.Builder(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobBuilder.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.jobBuilder.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.jobBuilder, request.jobBuilder);
        }

        public int hashCode() {
            return Objects.hash(this.jobBuilder);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

