/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.results.OverallBucket;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetOverallBucketsAction
extends Action<Response> {
    public static final GetOverallBucketsAction INSTANCE = new GetOverallBucketsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/results/overall_buckets/get";

    private GetOverallBucketsAction() {
        super(NAME);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<OverallBucket> overallBuckets;

        public Response() {
            this.overallBuckets = new QueryPage(Collections.emptyList(), 0L, OverallBucket.RESULTS_FIELD);
        }

        public Response(QueryPage<OverallBucket> overallBuckets) {
            this.overallBuckets = overallBuckets;
        }

        public QueryPage<OverallBucket> getOverallBuckets() {
            return this.overallBuckets;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.overallBuckets = new QueryPage(in, OverallBucket::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.overallBuckets.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.overallBuckets.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.overallBuckets);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.overallBuckets, other.overallBuckets);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField TOP_N = new ParseField("top_n", new String[0]);
        public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
        public static final ParseField OVERALL_SCORE = new ParseField("overall_score", new String[0]);
        public static final ParseField EXCLUDE_INTERIM = new ParseField("exclude_interim", new String[0]);
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        public static final ParseField ALLOW_NO_JOBS = new ParseField("allow_no_jobs", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/job/results/overall_buckets/get", Request::new);
        private String jobId;
        private int topN = 1;
        private TimeValue bucketSpan;
        private double overallScore = 0.0;
        private boolean excludeInterim = false;
        private Long start;
        private Long end;
        private boolean allowNoJobs = true;

        static long parseDateOrThrow(String date, ParseField paramName, LongSupplier now) {
            DateMathParser dateMathParser = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.toDateMathParser();
            try {
                return dateMathParser.parse(date, now).toEpochMilli();
            }
            catch (Exception e) {
                String msg = Messages.getMessage("Query param [{0}] with value [{1}] cannot be parsed as a date or converted to a number (epoch).", paramName.getPreferredName(), date);
                throw new ElasticsearchParseException(msg, (Throwable)e, new Object[0]);
            }
        }

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        public Request() {
        }

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public int getTopN() {
            return this.topN;
        }

        public void setTopN(int topN) {
            if (topN <= 0) {
                throw new IllegalArgumentException("[topN] parameter must be positive, found [" + topN + "]");
            }
            this.topN = topN;
        }

        public TimeValue getBucketSpan() {
            return this.bucketSpan;
        }

        public void setBucketSpan(TimeValue bucketSpan) {
            this.bucketSpan = bucketSpan;
        }

        public void setBucketSpan(String bucketSpan) {
            this.bucketSpan = TimeValue.parseTimeValue((String)bucketSpan, (String)BUCKET_SPAN.getPreferredName());
        }

        public double getOverallScore() {
            return this.overallScore;
        }

        public void setOverallScore(double overallScore) {
            this.overallScore = overallScore;
        }

        public boolean isExcludeInterim() {
            return this.excludeInterim;
        }

        public void setExcludeInterim(boolean excludeInterim) {
            this.excludeInterim = excludeInterim;
        }

        public Long getStart() {
            return this.start;
        }

        public void setStart(Long start) {
            this.start = start;
        }

        public void setStart(String start) {
            this.setStart(Request.parseDateOrThrow(start, START, System::currentTimeMillis));
        }

        public Long getEnd() {
            return this.end;
        }

        public void setEnd(Long end) {
            this.end = end;
        }

        public void setEnd(String end) {
            this.setEnd(Request.parseDateOrThrow(end, END, System::currentTimeMillis));
        }

        public boolean allowNoJobs() {
            return this.allowNoJobs;
        }

        public void setAllowNoJobs(boolean allowNoJobs) {
            this.allowNoJobs = allowNoJobs;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.topN = in.readVInt();
            this.bucketSpan = in.readOptionalTimeValue();
            this.overallScore = in.readDouble();
            this.excludeInterim = in.readBoolean();
            this.start = in.readOptionalLong();
            this.end = in.readOptionalLong();
            this.allowNoJobs = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeVInt(this.topN);
            out.writeOptionalTimeValue(this.bucketSpan);
            out.writeDouble(this.overallScore);
            out.writeBoolean(this.excludeInterim);
            out.writeOptionalLong(this.start);
            out.writeOptionalLong(this.end);
            out.writeBoolean(this.allowNoJobs);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(TOP_N.getPreferredName(), this.topN);
            if (this.bucketSpan != null) {
                builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan.getStringRep());
            }
            builder.field(OVERALL_SCORE.getPreferredName(), this.overallScore);
            builder.field(EXCLUDE_INTERIM.getPreferredName(), this.excludeInterim);
            if (this.start != null) {
                builder.field(START.getPreferredName(), String.valueOf(this.start));
            }
            if (this.end != null) {
                builder.field(END.getPreferredName(), String.valueOf(this.end));
            }
            builder.field(ALLOW_NO_JOBS.getPreferredName(), this.allowNoJobs);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.topN, this.bucketSpan, this.overallScore, this.excludeInterim, this.start, this.end, this.allowNoJobs);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != other.getClass()) {
                return false;
            }
            Request that = (Request)((Object)other);
            return Objects.equals(this.jobId, that.jobId) && this.topN == that.topN && Objects.equals(this.bucketSpan, that.bucketSpan) && this.excludeInterim == that.excludeInterim && this.overallScore == that.overallScore && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end) && this.allowNoJobs == that.allowNoJobs;
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareInt(Request::setTopN, TOP_N);
            PARSER.declareString(Request::setBucketSpan, BUCKET_SPAN);
            PARSER.declareDouble(Request::setOverallScore, OVERALL_SCORE);
            PARSER.declareBoolean(Request::setExcludeInterim, EXCLUDE_INTERIM);
            PARSER.declareString((request, startTime) -> request.setStart(Request.parseDateOrThrow(startTime, START, System::currentTimeMillis)), START);
            PARSER.declareString((request, endTime) -> request.setEnd(Request.parseDateOrThrow(endTime, END, System::currentTimeMillis)), END);
            PARSER.declareBoolean(Request::setAllowNoJobs, ALLOW_NO_JOBS);
        }
    }
}

