/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetModelSnapshotsAction
extends Action<Response> {
    public static final GetModelSnapshotsAction INSTANCE = new GetModelSnapshotsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/model_snapshots/get";

    private GetModelSnapshotsAction() {
        super(NAME);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        public RequestBuilder(ElasticsearchClient client, GetModelSnapshotsAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<ModelSnapshot> page;

        public Response(QueryPage<ModelSnapshot> page) {
            this.page = page;
        }

        public Response() {
        }

        public QueryPage<ModelSnapshot> getPage() {
            return this.page;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.page = new QueryPage(in, ModelSnapshot::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.page.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.page.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.page);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.page, other.page);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField SNAPSHOT_ID = new ParseField("snapshot_id", new String[0]);
        public static final ParseField SORT = new ParseField("sort", new String[0]);
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        public static final ParseField DESC = new ParseField("desc", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/job/model_snapshots/get", Request::new);
        private String jobId;
        private String snapshotId;
        private String sort;
        private String start;
        private String end;
        private boolean desc = true;
        private PageParams pageParams = new PageParams();

        public static Request parseRequest(String jobId, String snapshotId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            if (snapshotId != null) {
                request.snapshotId = snapshotId;
            }
            return request;
        }

        public Request() {
        }

        public Request(String jobId, String snapshotId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            this.snapshotId = snapshotId;
        }

        public String getJobId() {
            return this.jobId;
        }

        @Nullable
        public String getSnapshotId() {
            return this.snapshotId;
        }

        @Nullable
        public String getSort() {
            return this.sort;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }

        public boolean getDescOrder() {
            return this.desc;
        }

        public void setDescOrder(boolean desc) {
            this.desc = desc;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public void setPageParams(PageParams pageParams) {
            this.pageParams = ExceptionsHelper.requireNonNull(pageParams, PageParams.PAGE.getPreferredName());
        }

        @Nullable
        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = ExceptionsHelper.requireNonNull(start, START.getPreferredName());
        }

        @Nullable
        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = ExceptionsHelper.requireNonNull(end, END.getPreferredName());
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.snapshotId = in.readOptionalString();
            this.sort = in.readOptionalString();
            this.start = in.readOptionalString();
            this.end = in.readOptionalString();
            this.desc = in.readBoolean();
            this.pageParams = new PageParams(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeOptionalString(this.snapshotId);
            out.writeOptionalString(this.sort);
            out.writeOptionalString(this.start);
            out.writeOptionalString(this.end);
            out.writeBoolean(this.desc);
            this.pageParams.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            if (this.snapshotId != null) {
                builder.field(SNAPSHOT_ID.getPreferredName(), this.snapshotId);
            }
            if (this.start != null) {
                builder.field(START.getPreferredName(), this.start);
            }
            if (this.end != null) {
                builder.field(END.getPreferredName(), this.end);
            }
            if (this.sort != null) {
                builder.field(SORT.getPreferredName(), this.sort);
            }
            builder.field(DESC.getPreferredName(), this.desc);
            builder.field(PageParams.PAGE.getPreferredName(), (ToXContent)this.pageParams);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.snapshotId, this.start, this.end, this.sort, this.desc);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.snapshotId, other.snapshotId) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.sort, other.sort) && Objects.equals(this.desc, other.desc);
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareString((request, snapshotId) -> {
                request.snapshotId = snapshotId;
            }, SNAPSHOT_ID);
            PARSER.declareString(Request::setStart, START);
            PARSER.declareString(Request::setEnd, END);
            PARSER.declareString(Request::setSort, SORT);
            PARSER.declareBoolean(Request::setDescOrder, DESC);
            PARSER.declareObject(Request::setPageParams, PageParams.PARSER, PageParams.PAGE);
        }
    }
}

