/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetDatafeedsAction
extends Action<Response> {
    public static final GetDatafeedsAction INSTANCE = new GetDatafeedsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/datafeeds/get";
    public static final String ALL = "_all";

    private GetDatafeedsAction() {
        super(NAME);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<DatafeedConfig> datafeeds;

        public Response(QueryPage<DatafeedConfig> datafeeds) {
            this.datafeeds = datafeeds;
        }

        public Response() {
        }

        public QueryPage<DatafeedConfig> getResponse() {
            return this.datafeeds;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.datafeeds = new QueryPage(in, DatafeedConfig::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.datafeeds.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.datafeeds.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.datafeeds);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.datafeeds, other.datafeeds);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class RequestBuilder
    extends MasterNodeReadOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, GetDatafeedsAction action) {
            super(client, (Action)action, (MasterNodeReadRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        public static final ParseField ALLOW_NO_DATAFEEDS = new ParseField("allow_no_datafeeds", new String[0]);
        private String datafeedId;
        private boolean allowNoDatafeeds = true;

        public Request(String datafeedId) {
            this();
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
        }

        public Request() {
            this.local(true);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.datafeedId = in.readString();
            if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
                this.allowNoDatafeeds = in.readBoolean();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.datafeedId);
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeBoolean(this.allowNoDatafeeds);
            }
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public boolean allowNoDatafeeds() {
            return this.allowNoDatafeeds;
        }

        public void setAllowNoDatafeeds(boolean allowNoDatafeeds) {
            this.allowNoDatafeeds = allowNoDatafeeds;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId, this.allowNoDatafeeds);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.allowNoDatafeeds, other.allowNoDatafeeds);
        }
    }
}

