/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshotField;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DeleteModelSnapshotAction
extends Action<AcknowledgedResponse> {
    public static final DeleteModelSnapshotAction INSTANCE = new DeleteModelSnapshotAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/model_snapshots/delete";

    private DeleteModelSnapshotAction() {
        super(NAME);
    }

    public AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, AcknowledgedResponse> {
        public RequestBuilder(ElasticsearchClient client, DeleteModelSnapshotAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest {
        private String jobId;
        private String snapshotId;

        public Request() {
        }

        public Request(String jobId, String snapshotId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            this.snapshotId = ExceptionsHelper.requireNonNull(snapshotId, ModelSnapshotField.SNAPSHOT_ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.snapshotId = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeString(this.snapshotId);
        }
    }
}

