/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DeleteForecastAction
extends Action<AcknowledgedResponse> {
    public static final DeleteForecastAction INSTANCE = new DeleteForecastAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/forecast/delete";

    private DeleteForecastAction() {
        super(NAME);
    }

    public AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, AcknowledgedResponse> {
        public RequestBuilder(ElasticsearchClient client, DeleteForecastAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String jobId;
        private String forecastId;
        private boolean allowNoForecasts = true;

        public Request() {
        }

        public Request(String jobId, String forecastId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            this.forecastId = ExceptionsHelper.requireNonNull(forecastId, ForecastRequestStats.FORECAST_ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getForecastId() {
            return this.forecastId;
        }

        public boolean isAllowNoForecasts() {
            return this.allowNoForecasts;
        }

        public void setAllowNoForecasts(boolean allowNoForecasts) {
            this.allowNoForecasts = allowNoForecasts;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.forecastId = in.readString();
            this.allowNoForecasts = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeString(this.forecastId);
            out.writeBoolean(this.allowNoForecasts);
        }
    }
}

