/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContentObject;

public class RetryAction
extends Action<Response> {
    public static final RetryAction INSTANCE = new RetryAction();
    public static final String NAME = "indices:admin/ilm/retry";

    protected RetryAction() {
        super(NAME);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] indices = Strings.EMPTY_ARRAY;
        private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

        public Request(String ... indices) {
            this.indices = indices;
        }

        public Request() {
        }

        public Request indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public String[] indices() {
            return this.indices;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.indices = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.indices);
            this.indicesOptions.writeIndicesOptions(out);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.deepEquals(this.indices, other.indices) && Objects.equals(this.indicesOptions, other.indicesOptions);
        }
    }

    public static class Response
    extends AcknowledgedResponse
    implements ToXContentObject {
        public Response() {
        }

        public Response(boolean acknowledged) {
            super(acknowledged);
        }
    }
}

