/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.indexlifecycle.LifecyclePolicy;

public class PutLifecycleAction
extends Action<Response> {
    public static final PutLifecycleAction INSTANCE = new PutLifecycleAction();
    public static final String NAME = "cluster:admin/ilm/put";

    protected PutLifecycleAction() {
        super(NAME);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        public static final ParseField POLICY_FIELD = new ParseField("policy", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("put_lifecycle_request", a -> new Request((LifecyclePolicy)((Object)((Object)a[0]))));
        private LifecyclePolicy policy;

        public Request(LifecyclePolicy policy) {
            this.policy = policy;
        }

        public Request() {
        }

        public LifecyclePolicy getPolicy() {
            return this.policy;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public static Request parseRequest(String name, XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, (Object)name));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(POLICY_FIELD.getPreferredName(), (ToXContent)this.policy);
            builder.endObject();
            return builder;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.policy = new LifecyclePolicy(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.policy.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.policy});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals((Object)this.policy, (Object)other.policy);
        }

        public String toString() {
            return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), LifecyclePolicy::parse, POLICY_FIELD);
        }
    }

    public static class Response
    extends AcknowledgedResponse
    implements ToXContentObject {
        public Response() {
        }

        public Response(boolean acknowledged) {
            super(acknowledged);
        }
    }
}

