/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xpack.core.indexlifecycle.AsyncActionStep;
import org.elasticsearch.xpack.core.indexlifecycle.Step;

public class SetSingleNodeAllocateStep
extends AsyncActionStep {
    public static final String NAME = "set-single-node-allocation";
    private static final AllocationDeciders ALLOCATION_DECIDERS = new AllocationDeciders(Collections.singletonList(new FilterAllocationDecider(Settings.EMPTY, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS))));

    public SetSingleNodeAllocateStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public void performAction(IndexMetaData indexMetaData, ClusterState clusterState, ClusterStateObserver observer, AsyncActionStep.Listener listener) {
        RoutingAllocation allocation = new RoutingAllocation(ALLOCATION_DECIDERS, clusterState.getRoutingNodes(), clusterState, null, System.nanoTime());
        ArrayList<String> validNodeIds = new ArrayList<String>();
        Optional anyShard = clusterState.getRoutingTable().allShards(indexMetaData.getIndex().getName()).stream().findAny();
        if (anyShard.isPresent()) {
            for (RoutingNode node : clusterState.getRoutingNodes()) {
                boolean canRemainOnCurrentNode = ALLOCATION_DECIDERS.canRemain((ShardRouting)anyShard.get(), node, allocation).type() == Decision.Type.YES;
                if (!canRemainOnCurrentNode) continue;
                DiscoveryNode discoveryNode = node.node();
                validNodeIds.add(discoveryNode.getId());
            }
            Randomness.shuffle(validNodeIds);
            Optional nodeId = validNodeIds.stream().findAny();
            if (nodeId.isPresent()) {
                Settings settings = Settings.builder().put(IndexMetaData.INDEX_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_id", (String)nodeId.get()).build();
                UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest(new String[]{indexMetaData.getIndex().getName()}).settings(settings);
                this.getClient().admin().indices().updateSettings(updateSettingsRequest, ActionListener.wrap(response -> listener.onResponse(true), listener::onFailure));
            } else {
                listener.onResponse(false);
            }
        } else {
            listener.onFailure((Exception)new IndexNotFoundException(indexMetaData.getIndex()));
        }
    }
}

