/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ccr.action.FollowParameters;

public final class ResumeFollowAction
extends Action<AcknowledgedResponse> {
    public static final ResumeFollowAction INSTANCE = new ResumeFollowAction();
    public static final String NAME = "cluster:admin/xpack/ccr/resume_follow";

    private ResumeFollowAction() {
        super(NAME);
    }

    public AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        static final ObjectParser<FollowParameters, Void> PARSER = new ObjectParser("cluster:admin/xpack/ccr/resume_follow", FollowParameters::new);
        private String followerIndex;
        private FollowParameters parameters = new FollowParameters();

        public static Request fromXContent(XContentParser parser, String followerIndex) throws IOException {
            FollowParameters parameters = (FollowParameters)PARSER.parse(parser, null);
            Request request = new Request();
            request.setFollowerIndex(followerIndex);
            request.setParameters(parameters);
            return request;
        }

        public Request() {
        }

        public String getFollowerIndex() {
            return this.followerIndex;
        }

        public void setFollowerIndex(String followerIndex) {
            this.followerIndex = followerIndex;
        }

        public FollowParameters getParameters() {
            return this.parameters;
        }

        public void setParameters(FollowParameters parameters) {
            this.parameters = parameters;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = this.parameters.validate();
            if (this.followerIndex == null) {
                e = ValidateActions.addValidationError((String)"follower_index is missing", (ActionRequestValidationException)e);
            }
            return e;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.followerIndex = in.readString();
            this.parameters = new FollowParameters(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.followerIndex);
            this.parameters.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.parameters.toXContentFragment(builder);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.followerIndex, request.followerIndex) && Objects.equals(this.parameters, request.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.followerIndex, this.parameters);
        }

        static {
            FollowParameters.initParser(PARSER);
        }
    }
}

