/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.close.CloseIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.close.TransportCloseIndexAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.OpenIndexClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.FrozenEngine;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class TransportFreezeIndexAction
extends TransportMasterNodeAction<FreezeRequest, FreezeResponse> {
    private final DestructiveOperations destructiveOperations;
    private final MetaDataIndexStateService indexStateService;
    private final TransportCloseIndexAction transportCloseIndexAction;

    @Inject
    public TransportFreezeIndexAction(MetaDataIndexStateService indexStateService, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DestructiveOperations destructiveOperations, TransportCloseIndexAction transportCloseIndexAction) {
        super("indices:admin/freeze", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, () -> new FreezeRequest(new String[0]));
        this.destructiveOperations = destructiveOperations;
        this.indexStateService = indexStateService;
        this.transportCloseIndexAction = transportCloseIndexAction;
    }

    protected String executor() {
        return "same";
    }

    protected void doExecute(Task task, FreezeRequest request, ActionListener<FreezeResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(task, (MasterNodeRequest)request, listener);
    }

    protected FreezeResponse newResponse() {
        return new FreezeResponse();
    }

    private Index[] resolveIndices(FreezeRequest request, ClusterState state) {
        ArrayList<Index> indices = new ArrayList<Index>();
        for (Index index : this.indexNameExpressionResolver.concreteIndices(state, (IndicesRequest)request)) {
            IndexMetaData metaData = state.metaData().index(index);
            Settings settings = metaData.getSettings();
            if ((!request.freeze() || ((Boolean)FrozenEngine.INDEX_FROZEN.get(settings)).booleanValue()) && (request.freeze() || !((Boolean)FrozenEngine.INDEX_FROZEN.get(settings)).booleanValue())) continue;
            indices.add(index);
        }
        if (indices.isEmpty() && !request.indicesOptions().allowNoIndices()) {
            throw new ResourceNotFoundException("no index found to " + (request.freeze() ? "freeze" : "unfreeze"), new Object[0]);
        }
        return indices.toArray(Index.EMPTY_ARRAY);
    }

    protected void masterOperation(FreezeRequest request, ClusterState state, ActionListener<FreezeResponse> listener) {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    protected void masterOperation(Task task, final FreezeRequest request, ClusterState state, final ActionListener<FreezeResponse> listener) throws Exception {
        final Index[] concreteIndices = this.resolveIndices(request, state);
        if (concreteIndices.length == 0) {
            listener.onResponse((Object)new FreezeResponse(true, true));
            return;
        }
        CloseIndexClusterStateUpdateRequest closeRequest = (CloseIndexClusterStateUpdateRequest)((CloseIndexClusterStateUpdateRequest)((CloseIndexClusterStateUpdateRequest)new CloseIndexClusterStateUpdateRequest(task.getId()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices);
        this.indexStateService.closeIndices(closeRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                if (response.isAcknowledged()) {
                    TransportFreezeIndexAction.this.toggleFrozenSettings(concreteIndices, request, (ActionListener<FreezeResponse>)listener);
                } else {
                    listener.onResponse((Object)new FreezeResponse(false, false));
                }
            }

            public void onFailure(Exception t) {
                TransportFreezeIndexAction.this.logger.debug(() -> new ParameterizedMessage("failed to close indices [{}]", (Object)concreteIndices), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    private void toggleFrozenSettings(final Index[] concreteIndices, final FreezeRequest request, final ActionListener<FreezeResponse> listener) {
        this.clusterService.submitStateUpdateTask("toggle-frozen-settings", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<AcknowledgedResponse>(Priority.URGENT, (AckedRequest)request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                OpenIndexClusterStateUpdateRequest updateRequest = ((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)new OpenIndexClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices)).waitForActiveShards(request.waitForActiveShards());
                TransportFreezeIndexAction.this.indexStateService.openIndex(updateRequest, (ActionListener)new ActionListener<OpenIndexClusterStateUpdateResponse>(){

                    public void onResponse(OpenIndexClusterStateUpdateResponse openIndexClusterStateUpdateResponse) {
                        listener.onResponse((Object)new FreezeResponse(openIndexClusterStateUpdateResponse.isAcknowledged(), openIndexClusterStateUpdateResponse.isShardsAcknowledged()));
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }){

            public ClusterState execute(ClusterState currentState) {
                MetaData.Builder builder = MetaData.builder((MetaData)currentState.metaData());
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                for (Index index : concreteIndices) {
                    IndexMetaData meta = currentState.metaData().getIndexSafe(index);
                    if (meta.getState() != IndexMetaData.State.CLOSE) {
                        throw new IllegalStateException("index [" + index.getName() + "] is not closed");
                    }
                    IndexMetaData.Builder imdBuilder = IndexMetaData.builder((IndexMetaData)meta);
                    imdBuilder.settingsVersion(meta.getSettingsVersion() + 1L);
                    Settings.Builder settingsBuilder = Settings.builder().put(currentState.metaData().index(index).getSettings()).put(FrozenEngine.INDEX_FROZEN.getKey(), request.freeze()).put(IndexSettings.INDEX_SEARCH_THROTTLED.getKey(), request.freeze());
                    if (request.freeze()) {
                        settingsBuilder.put("index.blocks.write", true);
                        blocks.addIndexBlock(index.getName(), IndexMetaData.INDEX_WRITE_BLOCK);
                    } else {
                        settingsBuilder.remove("index.blocks.write");
                        blocks.removeIndexBlock(index.getName(), IndexMetaData.INDEX_WRITE_BLOCK);
                    }
                    imdBuilder.settings(settingsBuilder);
                    builder.put(imdBuilder.build(), true);
                }
                return ClusterState.builder((ClusterState)currentState).blocks(blocks).metaData(builder).build();
            }

            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }
        });
    }

    protected ClusterBlockException checkBlock(FreezeRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }

    public static class FreezeRequest
    extends AcknowledgedRequest<FreezeRequest>
    implements IndicesRequest.Replaceable {
        private String[] indices;
        private boolean freeze = true;
        private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
        private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;

        public FreezeRequest(String ... indices) {
            this.indices = indices;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (CollectionUtils.isEmpty((Object[])this.indices)) {
                validationException = ValidateActions.addValidationError((String)"index is missing", validationException);
            }
            return validationException;
        }

        public FreezeRequest setFreeze(boolean freeze) {
            this.freeze = freeze;
            return this;
        }

        public boolean freeze() {
            return this.freeze;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
            this.indices = in.readStringArray();
            this.freeze = in.readBoolean();
            this.waitForActiveShards = ActiveShardCount.readFrom((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.indicesOptions.writeIndicesOptions(out);
            out.writeStringArray(this.indices);
            out.writeBoolean(this.freeze);
            this.waitForActiveShards.writeTo(out);
        }

        public String[] indices() {
            return this.indices;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public FreezeRequest indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        public IndicesRequest indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public ActiveShardCount waitForActiveShards() {
            return this.waitForActiveShards;
        }

        public FreezeRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
            this.waitForActiveShards = waitForActiveShards;
            return this;
        }
    }

    public static class FreezeIndexAction
    extends Action<FreezeResponse> {
        public static final FreezeIndexAction INSTANCE = new FreezeIndexAction();
        public static final String NAME = "indices:admin/freeze";

        private FreezeIndexAction() {
            super(NAME);
        }

        public FreezeResponse newResponse() {
            return new FreezeResponse();
        }
    }

    public static class FreezeResponse
    extends OpenIndexResponse {
        public FreezeResponse() {
        }

        public FreezeResponse(boolean acknowledged, boolean shardsAcknowledged) {
            super(acknowledged, shardsAcknowledged);
        }
    }
}

