/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.license.DeleteLicenseAction;
import org.elasticsearch.license.GetBasicStatusAction;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetTrialStatusAction;
import org.elasticsearch.license.LicensesMetaData;
import org.elasticsearch.license.PostStartBasicAction;
import org.elasticsearch.license.PostStartTrialAction;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.RestDeleteLicenseAction;
import org.elasticsearch.license.RestGetBasicStatus;
import org.elasticsearch.license.RestGetLicenseAction;
import org.elasticsearch.license.RestGetTrialStatus;
import org.elasticsearch.license.RestPostStartBasicLicense;
import org.elasticsearch.license.RestPostStartTrialLicense;
import org.elasticsearch.license.RestPutLicenseAction;
import org.elasticsearch.license.TransportDeleteLicenseAction;
import org.elasticsearch.license.TransportGetBasicStatusAction;
import org.elasticsearch.license.TransportGetLicenseAction;
import org.elasticsearch.license.TransportGetTrialStatusAction;
import org.elasticsearch.license.TransportPostStartBasicAction;
import org.elasticsearch.license.TransportPostStartTrialAction;
import org.elasticsearch.license.TransportPutLicenseAction;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;

public class Licensing
implements ActionPlugin {
    public static final String NAME = "license";
    protected final Settings settings;

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(MetaData.Custom.class, "licenses", LicensesMetaData::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "licenses", LicensesMetaData::readDiffFrom));
        return entries;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.add(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("licenses", new String[0]), LicensesMetaData::fromXContent));
        return entries;
    }

    public Licensing(Settings settings) {
        this.settings = settings;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((Action)PutLicenseAction.INSTANCE, TransportPutLicenseAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)GetLicenseAction.INSTANCE, TransportGetLicenseAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)DeleteLicenseAction.INSTANCE, TransportDeleteLicenseAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)PostStartTrialAction.INSTANCE, TransportPostStartTrialAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)GetTrialStatusAction.INSTANCE, TransportGetTrialStatusAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)PostStartBasicAction.INSTANCE, TransportPostStartBasicAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)GetBasicStatusAction.INSTANCE, TransportGetBasicStatusAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new RestGetLicenseAction(settings, restController));
        handlers.add((RestHandler)new RestPutLicenseAction(settings, restController));
        handlers.add((RestHandler)new RestDeleteLicenseAction(settings, restController));
        handlers.add((RestHandler)new RestGetTrialStatus(settings, restController));
        handlers.add((RestHandler)new RestGetBasicStatus(settings, restController));
        handlers.add((RestHandler)new RestPostStartTrialLicense(settings, restController));
        handlers.add((RestHandler)new RestPostStartBasicLicense(settings, restController));
        return handlers;
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(Setting.groupSetting((String)"license.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    }
}

