/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.action.SqlQueryAction;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.action.SqlQueryResponse;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.Protocol;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlQueryRequestBuilder
extends ActionRequestBuilder<SqlQueryRequest, SqlQueryResponse> {
    public SqlQueryRequestBuilder(ElasticsearchClient client, SqlQueryAction action) {
        this(client, action, "", Collections.emptyList(), null, Protocol.TIME_ZONE, 1000, Protocol.REQUEST_TIMEOUT, Protocol.PAGE_TIMEOUT, "", new RequestInfo(Mode.PLAIN), false);
    }

    public SqlQueryRequestBuilder(ElasticsearchClient client, SqlQueryAction action, String query, List<SqlTypedParamValue> params, QueryBuilder filter, ZoneId zoneId, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, String nextPageInfo, RequestInfo requestInfo, boolean multiValueFieldLeniency) {
        super(client, (Action)action, (ActionRequest)new SqlQueryRequest(query, params, filter, zoneId, fetchSize, requestTimeout, pageTimeout, nextPageInfo, requestInfo, multiValueFieldLeniency));
    }

    public SqlQueryRequestBuilder query(String query) {
        ((SqlQueryRequest)this.request).query(query);
        return this;
    }

    public SqlQueryRequestBuilder mode(String mode) {
        ((SqlQueryRequest)this.request).mode(mode);
        return this;
    }

    public SqlQueryRequestBuilder mode(Mode mode) {
        ((SqlQueryRequest)this.request).mode(mode);
        return this;
    }

    public SqlQueryRequestBuilder cursor(String cursor) {
        ((SqlQueryRequest)this.request).cursor(cursor);
        return this;
    }

    public SqlQueryRequestBuilder filter(QueryBuilder filter) {
        ((SqlQueryRequest)this.request).filter(filter);
        return this;
    }

    public SqlQueryRequestBuilder zoneId(ZoneId zoneId) {
        ((SqlQueryRequest)this.request).zoneId(zoneId);
        return this;
    }

    public SqlQueryRequestBuilder requestTimeout(TimeValue timeout) {
        ((SqlQueryRequest)this.request).requestTimeout(timeout);
        return this;
    }

    public SqlQueryRequestBuilder pageTimeout(TimeValue timeout) {
        ((SqlQueryRequest)this.request).pageTimeout(timeout);
        return this;
    }

    public SqlQueryRequestBuilder fetchSize(int fetchSize) {
        ((SqlQueryRequest)this.request).fetchSize(fetchSize);
        return this;
    }

    public SqlQueryRequestBuilder multiValueFieldLeniency(boolean lenient) {
        ((SqlQueryRequest)this.request).fieldMultiValueLeniency(lenient);
        return this;
    }
}

