/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.rest;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.rollup.action.DeleteRollupJobAction;

public class RestDeleteRollupJobAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestDeleteRollupJobAction.class));
    public static final ParseField ID = new ParseField("id", new String[0]);

    public RestDeleteRollupJobAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.DELETE, "/_rollup/job/{id}", (RestHandler)this, RestRequest.Method.DELETE, "/_xpack/rollup/job/{id}/", deprecationLogger);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String id = restRequest.param(ID.getPreferredName());
        DeleteRollupJobAction.Request request = new DeleteRollupJobAction.Request(id);
        return channel -> client.execute((Action)DeleteRollupJobAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener<DeleteRollupJobAction.Response>(channel){

            protected RestStatus getStatus(DeleteRollupJobAction.Response response) {
                if (response.getNodeFailures().size() > 0 || response.getTaskFailures().size() > 0) {
                    return RestStatus.INTERNAL_SERVER_ERROR;
                }
                return RestStatus.OK;
            }
        });
    }

    public String getName() {
        return "delete_rollup_job";
    }
}

