/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.metrics.InternalAvg;
import org.elasticsearch.search.aggregations.metrics.InternalMax;
import org.elasticsearch.search.aggregations.metrics.InternalMin;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalSum;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.xpack.core.rollup.RollupField;

public class RollupResponseTranslator {
    private static final Logger logger = LogManager.getLogger(RollupResponseTranslator.class);

    public static SearchResponse verifyResponse(MultiSearchResponse.Item normalResponse) {
        if (normalResponse.isFailure()) {
            throw new RuntimeException(normalResponse.getFailureMessage(), normalResponse.getFailure());
        }
        return normalResponse.getResponse();
    }

    public static SearchResponse translateResponse(MultiSearchResponse.Item[] rolledMsearch, InternalAggregation.ReduceContext reduceContext) {
        List<SearchResponse> responses = Arrays.stream(rolledMsearch).map(item -> {
            if (item.isFailure()) {
                throw new RuntimeException(item.getFailureMessage(), item.getFailure());
            }
            return item.getResponse();
        }).collect(Collectors.toList());
        return RollupResponseTranslator.doCombineResponse(null, responses, reduceContext);
    }

    public static SearchResponse combineResponses(MultiSearchResponse.Item[] msearchResponses, InternalAggregation.ReduceContext reduceContext) {
        List<SearchResponse> rolledResponses;
        boolean liveMissing = false;
        assert (msearchResponses.length >= 2);
        MultiSearchResponse.Item liveResponse = msearchResponses[0];
        if (liveResponse.isFailure()) {
            Exception e = liveResponse.getFailure();
            if (e instanceof IndexNotFoundException) {
                logger.warn("\"Live\" index not found during rollup search.", (Throwable)e);
                liveMissing = true;
            } else {
                throw new RuntimeException(liveResponse.getFailureMessage(), liveResponse.getFailure());
            }
        }
        if ((rolledResponses = Arrays.stream(msearchResponses).skip(1L).map(item -> {
            if (item.isFailure()) {
                Exception e = item.getFailure();
                if (!(e instanceof IndexNotFoundException)) {
                    throw new RuntimeException(item.getFailureMessage(), item.getFailure());
                }
                logger.warn("Rollup index not found during rollup search.", (Throwable)e);
                return null;
            }
            return item.getResponse();
        }).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty() && !liveMissing) {
            return RollupResponseTranslator.verifyResponse(liveResponse);
        }
        if (rolledResponses.isEmpty() && liveMissing) {
            throw new RuntimeException("No indices (live or rollup) found during rollup search");
        }
        return RollupResponseTranslator.doCombineResponse(liveResponse.getResponse(), rolledResponses, reduceContext);
    }

    private static SearchResponse doCombineResponse(SearchResponse liveResponse, List<SearchResponse> rolledResponses, InternalAggregation.ReduceContext reduceContext) {
        InternalAggregations liveAggs = liveResponse != null ? (InternalAggregations)liveResponse.getAggregations() : InternalAggregations.EMPTY;
        int missingRollupAggs = rolledResponses.stream().mapToInt(searchResponse -> {
            if (searchResponse == null || searchResponse.getAggregations() == null || searchResponse.getAggregations().asList().size() == 0) {
                return 1;
            }
            return 0;
        }).sum();
        if (missingRollupAggs == rolledResponses.size()) {
            return RollupResponseTranslator.mergeFinalResponse(liveResponse, rolledResponses, InternalAggregations.EMPTY);
        }
        if (missingRollupAggs > 0 && missingRollupAggs != rolledResponses.size()) {
            throw new RuntimeException("Expected to find aggregations in rollup response, but none found.");
        }
        InternalAggregations currentTree = new InternalAggregations(Collections.emptyList());
        for (SearchResponse rolledResponse : rolledResponses) {
            ArrayList<InternalAggregation> unrolledAggs = new ArrayList<InternalAggregation>(rolledResponse.getAggregations().asList().size());
            for (Aggregation agg : rolledResponse.getAggregations()) {
                if (!(agg instanceof InternalFilter)) {
                    throw new RuntimeException("Expected [" + agg.getName() + "] to be a FilterAggregation, but was [" + agg.getClass().getSimpleName() + "]");
                }
                unrolledAggs.addAll(RollupResponseTranslator.unrollAgg(((InternalFilter)agg).getAggregations(), liveAggs, currentTree));
            }
            InternalAggregations finalUnrolledAggs = new InternalAggregations(unrolledAggs);
            currentTree = InternalAggregations.reduce(Arrays.asList(currentTree, finalUnrolledAggs), (InternalAggregation.ReduceContext)new InternalAggregation.ReduceContext(reduceContext.bigArrays(), reduceContext.scriptService(), true));
        }
        if (liveAggs.asList().size() != 0) {
            currentTree = InternalAggregations.reduce(Arrays.asList(currentTree, liveAggs), (InternalAggregation.ReduceContext)new InternalAggregation.ReduceContext(reduceContext.bigArrays(), reduceContext.scriptService(), true));
        }
        return RollupResponseTranslator.mergeFinalResponse(liveResponse, rolledResponses, currentTree);
    }

    private static SearchResponse mergeFinalResponse(SearchResponse liveResponse, List<SearchResponse> rolledResponses, InternalAggregations aggs) {
        int totalShards = rolledResponses.stream().mapToInt(SearchResponse::getTotalShards).sum();
        int sucessfulShards = rolledResponses.stream().mapToInt(SearchResponse::getSuccessfulShards).sum();
        int skippedShards = rolledResponses.stream().mapToInt(SearchResponse::getSkippedShards).sum();
        long took = rolledResponses.stream().mapToLong(r -> r.getTook().getMillis()).sum();
        boolean isTimedOut = rolledResponses.stream().anyMatch(SearchResponse::isTimedOut);
        boolean isTerminatedEarly = rolledResponses.stream().filter(r -> r.isTerminatedEarly() != null).anyMatch(SearchResponse::isTerminatedEarly);
        int numReducePhases = rolledResponses.stream().mapToInt(SearchResponse::getNumReducePhases).sum();
        if (liveResponse != null) {
            totalShards += liveResponse.getTotalShards();
            sucessfulShards += liveResponse.getSuccessfulShards();
            skippedShards += liveResponse.getSkippedShards();
            took = Math.max(took, liveResponse.getTook().getMillis());
            isTimedOut = isTimedOut && liveResponse.isTimedOut();
            isTerminatedEarly = isTerminatedEarly && liveResponse.isTerminatedEarly() != false;
            numReducePhases += liveResponse.getNumReducePhases();
        }
        InternalSearchResponse combinedInternal = new InternalSearchResponse(SearchHits.empty(), aggs, null, null, isTimedOut, Boolean.valueOf(isTerminatedEarly), numReducePhases);
        return new SearchResponse((SearchResponseSections)combinedInternal, null, totalShards, sucessfulShards, skippedShards, took, ShardSearchFailure.EMPTY_ARRAY, rolledResponses.get(0).getClusters());
    }

    private static List<InternalAggregation> unrollAgg(InternalAggregations rolled, InternalAggregations original, InternalAggregations currentTree) {
        return rolled.asList().stream().filter(subAgg -> !subAgg.getName().endsWith("._count")).map(agg -> {
            long count = -1L;
            if (!(agg instanceof InternalMultiBucketAggregation)) {
                count = RollupResponseTranslator.getAggCount(agg, rolled.getAsMap());
            }
            return RollupResponseTranslator.unrollAgg((InternalAggregation)agg, (InternalAggregation)original.get(agg.getName()), (InternalAggregation)currentTree.get(agg.getName()), count);
        }).collect(Collectors.toList());
    }

    protected static InternalAggregation unrollAgg(InternalAggregation rolled, InternalAggregation originalAgg, InternalAggregation currentTree, long count) {
        if (rolled instanceof InternalMultiBucketAggregation) {
            return RollupResponseTranslator.unrollMultiBucket((InternalMultiBucketAggregation)rolled, (InternalMultiBucketAggregation)originalAgg, (InternalMultiBucketAggregation)currentTree);
        }
        if (rolled instanceof InternalNumericMetricsAggregation.SingleValue) {
            return RollupResponseTranslator.unrollMetric((InternalNumericMetricsAggregation.SingleValue)rolled, count);
        }
        throw new RuntimeException("Unable to unroll aggregation tree.  Aggregation [" + rolled.getName() + "] is of type [" + rolled.getClass().getSimpleName() + "] which is currently unsupported.");
    }

    private static InternalAggregation unrollMultiBucket(InternalMultiBucketAggregation rolled, InternalMultiBucketAggregation original, InternalMultiBucketAggregation currentTree) {
        if (rolled instanceof InternalDateHistogram) {
            return RollupResponseTranslator.unrollMultiBucket(rolled, original, currentTree, (bucket, bucketCount, subAggs) -> {
                long key = ((InternalDateHistogram)rolled).getKey((MultiBucketsAggregation.Bucket)bucket).longValue();
                DocValueFormat formatter = ((InternalDateHistogram.Bucket)bucket).getFormatter();
                assert (bucketCount >= 0L);
                return new InternalDateHistogram.Bucket(key, bucketCount.longValue(), ((InternalDateHistogram.Bucket)bucket).getKeyed(), formatter, subAggs);
            });
        }
        if (rolled instanceof InternalHistogram) {
            return RollupResponseTranslator.unrollMultiBucket(rolled, original, currentTree, (bucket, bucketCount, subAggs) -> {
                long key = ((InternalHistogram)rolled).getKey((MultiBucketsAggregation.Bucket)bucket).longValue();
                DocValueFormat formatter = ((InternalHistogram.Bucket)bucket).getFormatter();
                assert (bucketCount >= 0L);
                return new InternalHistogram.Bucket((double)key, bucketCount.longValue(), ((InternalHistogram.Bucket)bucket).getKeyed(), formatter, subAggs);
            });
        }
        if (rolled instanceof StringTerms) {
            return RollupResponseTranslator.unrollMultiBucket(rolled, original, currentTree, (bucket, bucketCount, subAggs) -> {
                BytesRef key = new BytesRef(bucket.getKeyAsString().getBytes(StandardCharsets.UTF_8));
                assert (bucketCount >= 0L);
                return new StringTerms.Bucket(key, bucketCount.longValue(), subAggs, false, 0L, DocValueFormat.RAW);
            });
        }
        if (rolled instanceof LongTerms) {
            return RollupResponseTranslator.unrollMultiBucket(rolled, original, currentTree, (bucket, bucketCount, subAggs) -> {
                long key = (Long)bucket.getKey();
                assert (bucketCount >= 0L);
                return new LongTerms.Bucket(key, bucketCount.longValue(), subAggs, false, 0L, DocValueFormat.RAW);
            });
        }
        throw new RuntimeException("Unable to unroll aggregation tree.  Aggregation [" + rolled.getName() + "] is of type [" + rolled.getClass().getSimpleName() + "] which is currently unsupported.");
    }

    private static <A extends InternalMultiBucketAggregation, B extends InternalMultiBucketAggregation.InternalBucket, T extends InternalMultiBucketAggregation<A, B>> InternalAggregation unrollMultiBucket(T source, T original, T currentTree, TriFunction<InternalMultiBucketAggregation.InternalBucket, Long, InternalAggregations, B> bucketFactory) {
        HashMap originalKeys = new HashMap();
        HashMap currentKeys = new HashMap();
        if (original != null) {
            original.getBuckets().forEach(b -> originalKeys.put(b.getKey(), b));
        }
        if (currentTree != null) {
            currentTree.getBuckets().forEach(b -> currentKeys.put(b.getKey(), b));
        }
        List buckets = source.getBuckets().stream().filter(b -> !originalKeys.containsKey(b.getKey())).map(bucket -> {
            long bucketCount = RollupResponseTranslator.getAggCount((Aggregation)source, bucket.getAggregations().getAsMap());
            if (bucketCount == 0L) {
                return null;
            }
            if (currentKeys.containsKey(bucket.getKey()) && ((InternalMultiBucketAggregation.InternalBucket)currentKeys.get(bucket.getKey())).getDocCount() != 0L) {
                bucketCount = 0L;
            }
            InternalAggregations subAggs = RollupResponseTranslator.unrollSubAggsFromMulti(bucket, (InternalMultiBucketAggregation.InternalBucket)originalKeys.get(bucket.getKey()), (InternalMultiBucketAggregation.InternalBucket)currentKeys.get(bucket.getKey()));
            return (InternalMultiBucketAggregation.InternalBucket)bucketFactory.apply(bucket, (Object)bucketCount, (Object)subAggs);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return source.create(buckets);
    }

    private static InternalAggregations unrollSubAggsFromMulti(InternalMultiBucketAggregation.InternalBucket bucket, InternalMultiBucketAggregation.InternalBucket original, InternalMultiBucketAggregation.InternalBucket currentTree) {
        return new InternalAggregations(bucket.getAggregations().asList().stream().filter(subAgg -> !subAgg.getName().endsWith("._count")).map(subAgg -> {
            long count = RollupResponseTranslator.getAggCount(subAgg, bucket.getAggregations().asMap());
            InternalAggregation originalSubAgg = null;
            if (original != null && original.getAggregations() != null) {
                originalSubAgg = (InternalAggregation)original.getAggregations().get(subAgg.getName());
            }
            InternalAggregation currentSubAgg = null;
            if (currentTree != null && currentTree.getAggregations() != null) {
                currentSubAgg = (InternalAggregation)currentTree.getAggregations().get(subAgg.getName());
            }
            return RollupResponseTranslator.unrollAgg((InternalAggregation)subAgg, originalSubAgg, currentSubAgg, count);
        }).collect(Collectors.toList()));
    }

    private static InternalAggregation unrollMetric(InternalNumericMetricsAggregation.SingleValue metric, long count) {
        if (metric instanceof InternalMax || metric instanceof InternalMin) {
            return metric;
        }
        if (metric instanceof InternalSum) {
            if (count != -1L) {
                return new InternalAvg(metric.getName().replace(".value", ""), metric.value(), count, DocValueFormat.RAW, metric.pipelineAggregators(), metric.getMetaData());
            }
            return metric;
        }
        throw new RuntimeException("Unable to unroll metric.  Aggregation [" + metric.getName() + "] is of type [" + metric.getClass().getSimpleName() + "] which is currently unsupported.");
    }

    private static long getAggCount(Aggregation agg, Map<String, Aggregation> aggMap) {
        String countPath = null;
        if (agg.getType().equals("date_histogram") || agg.getType().equals("histogram") || agg.getType().equals("sterms") || agg.getType().equals("lterms")) {
            countPath = RollupField.formatCountAggName((String)agg.getName());
        } else if (agg.getType().equals("sum")) {
            countPath = RollupField.formatCountAggName((String)agg.getName().replace(".value", ""));
        }
        if (countPath != null && aggMap.get(countPath) != null) {
            assert (aggMap.get(countPath) instanceof InternalSum);
            return (long)((InternalSum)aggMap.get(countPath)).getValue();
        }
        return -1L;
    }
}

