/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.joda.time.DateTimeZone;

public class RollupRequestTranslator {
    public static List<AggregationBuilder> translateAggregation(AggregationBuilder source, List<QueryBuilder> filterConditions, NamedWriteableRegistry registry) {
        if (source.getWriteableName().equals("date_histogram")) {
            return RollupRequestTranslator.translateDateHistogram((DateHistogramAggregationBuilder)source, filterConditions, registry);
        }
        if (source.getWriteableName().equals("histogram")) {
            return RollupRequestTranslator.translateHistogram((HistogramAggregationBuilder)source, filterConditions, registry);
        }
        if (RollupField.SUPPORTED_METRICS.contains(source.getWriteableName())) {
            return RollupRequestTranslator.translateVSLeaf((ValuesSourceAggregationBuilder.LeafOnly)source, registry);
        }
        if (source.getWriteableName().equals("terms")) {
            return RollupRequestTranslator.translateTerms((TermsAggregationBuilder)source, filterConditions, registry);
        }
        throw new IllegalArgumentException("Unable to translate aggregation tree into Rollup.  Aggregation [" + source.getName() + "] is of type [" + source.getClass().getSimpleName() + "] which is currently unsupported.");
    }

    private static List<AggregationBuilder> translateDateHistogram(DateHistogramAggregationBuilder source, List<QueryBuilder> filterConditions, NamedWriteableRegistry registry) {
        return RollupRequestTranslator.translateVSAggBuilder((ValuesSourceAggregationBuilder)source, filterConditions, registry, () -> {
            DateHistogramAggregationBuilder rolledDateHisto = new DateHistogramAggregationBuilder(source.getName());
            if (source.dateHistogramInterval() != null) {
                rolledDateHisto.dateHistogramInterval(source.dateHistogramInterval());
            } else {
                rolledDateHisto.interval(source.interval());
            }
            String timezone = source.timeZone() == null ? DateTimeZone.UTC.toString() : source.timeZone().toString();
            filterConditions.add((QueryBuilder)new TermQueryBuilder(RollupField.formatFieldName((ValuesSourceAggregationBuilder)source, (String)"time_zone"), timezone));
            if (source.timeZone() != null) {
                rolledDateHisto.timeZone(source.timeZone());
            }
            rolledDateHisto.offset(source.offset());
            if (source.extendedBounds() != null) {
                rolledDateHisto.extendedBounds(source.extendedBounds());
            }
            if (!Strings.isNullOrEmpty((String)source.format())) {
                rolledDateHisto.format(source.format());
            }
            rolledDateHisto.keyed(source.keyed());
            rolledDateHisto.minDocCount(source.minDocCount());
            rolledDateHisto.order(source.order());
            rolledDateHisto.field(RollupField.formatFieldName((ValuesSourceAggregationBuilder)source, (String)"timestamp"));
            rolledDateHisto.setMetaData(source.getMetaData());
            return rolledDateHisto;
        });
    }

    private static List<AggregationBuilder> translateHistogram(HistogramAggregationBuilder source, List<QueryBuilder> filterConditions, NamedWriteableRegistry registry) {
        return RollupRequestTranslator.translateVSAggBuilder((ValuesSourceAggregationBuilder)source, filterConditions, registry, () -> {
            HistogramAggregationBuilder rolledHisto = new HistogramAggregationBuilder(source.getName());
            rolledHisto.interval(source.interval());
            rolledHisto.offset(source.offset());
            if (Double.isFinite(source.minBound()) && Double.isFinite(source.maxBound())) {
                rolledHisto.extendedBounds(source.minBound(), source.maxBound());
            }
            rolledHisto.keyed(source.keyed());
            rolledHisto.minDocCount(source.minDocCount());
            rolledHisto.order(source.order());
            rolledHisto.field(RollupField.formatFieldName((ValuesSourceAggregationBuilder)source, (String)"value"));
            rolledHisto.setMetaData(source.getMetaData());
            return rolledHisto;
        });
    }

    private static List<AggregationBuilder> translateTerms(TermsAggregationBuilder source, List<QueryBuilder> filterConditions, NamedWriteableRegistry registry) {
        return RollupRequestTranslator.translateVSAggBuilder((ValuesSourceAggregationBuilder)source, filterConditions, registry, () -> {
            TermsAggregationBuilder rolledTerms = new TermsAggregationBuilder(source.getName(), source.valueType());
            rolledTerms.field(RollupField.formatFieldName((ValuesSourceAggregationBuilder)source, (String)"value"));
            rolledTerms.includeExclude(source.includeExclude());
            if (source.collectMode() != null) {
                rolledTerms.collectMode(source.collectMode());
            }
            rolledTerms.minDocCount(source.minDocCount());
            rolledTerms.executionHint(source.executionHint());
            if (source.order() != null) {
                rolledTerms.order(source.order());
            }
            rolledTerms.shardMinDocCount(source.shardMinDocCount());
            if (source.shardSize() > 0) {
                rolledTerms.shardSize(source.shardSize());
            }
            rolledTerms.showTermDocCountError(source.showTermDocCountError());
            rolledTerms.size(source.size());
            return rolledTerms;
        });
    }

    private static <T extends ValuesSourceAggregationBuilder> List<AggregationBuilder> translateVSAggBuilder(ValuesSourceAggregationBuilder source, List<QueryBuilder> filterConditions, NamedWriteableRegistry registry, Supplier<T> factory) {
        ValuesSourceAggregationBuilder rolled = (ValuesSourceAggregationBuilder)factory.get();
        for (AggregationBuilder subAgg : source.getSubAggregations()) {
            List<AggregationBuilder> translated = RollupRequestTranslator.translateAggregation(subAgg, filterConditions, registry);
            for (AggregationBuilder t : translated) {
                rolled.subAggregation(t);
            }
        }
        rolled.subAggregation((AggregationBuilder)new SumAggregationBuilder(RollupField.formatCountAggName((String)source.getName())).field(RollupField.formatFieldName((ValuesSourceAggregationBuilder)source, (String)"_count")));
        return Collections.singletonList(rolled);
    }

    /*
     * Exception decompiling
     */
    private static List<AggregationBuilder> translateVSLeaf(ValuesSourceAggregationBuilder.LeafOnly metric, NamedWriteableRegistry registry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

