/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.repositories.PutCcrRestoreSessionRequest;
import org.elasticsearch.xpack.ccr.repository.CcrRestoreSourceService;

public class PutCcrRestoreSessionAction
extends Action<PutCcrRestoreSessionResponse> {
    public static final PutCcrRestoreSessionAction INSTANCE = new PutCcrRestoreSessionAction();
    public static final String NAME = "internal:admin/ccr/restore/session/put";

    private PutCcrRestoreSessionAction() {
        super(NAME);
    }

    public PutCcrRestoreSessionResponse newResponse() {
        return new PutCcrRestoreSessionResponse();
    }

    public Writeable.Reader<PutCcrRestoreSessionResponse> getResponseReader() {
        return PutCcrRestoreSessionResponse::new;
    }

    public static class PutCcrRestoreSessionResponse
    extends ActionResponse {
        private DiscoveryNode node;
        private Store.MetadataSnapshot storeFileMetaData;
        private long mappingVersion;

        PutCcrRestoreSessionResponse() {
        }

        PutCcrRestoreSessionResponse(DiscoveryNode node, Store.MetadataSnapshot storeFileMetaData, long mappingVersion) {
            this.node = node;
            this.storeFileMetaData = storeFileMetaData;
            this.mappingVersion = mappingVersion;
        }

        PutCcrRestoreSessionResponse(StreamInput in) throws IOException {
            super(in);
            this.node = new DiscoveryNode(in);
            this.storeFileMetaData = new Store.MetadataSnapshot(in);
            this.mappingVersion = in.readVLong();
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.node = new DiscoveryNode(in);
            this.storeFileMetaData = new Store.MetadataSnapshot(in);
            this.mappingVersion = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.node.writeTo(out);
            this.storeFileMetaData.writeTo(out);
            out.writeVLong(this.mappingVersion);
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public Store.MetadataSnapshot getStoreFileMetaData() {
            return this.storeFileMetaData;
        }

        public long getMappingVersion() {
            return this.mappingVersion;
        }
    }

    public static class TransportPutCcrRestoreSessionAction
    extends TransportSingleShardAction<PutCcrRestoreSessionRequest, PutCcrRestoreSessionResponse> {
        private final IndicesService indicesService;
        private final CcrRestoreSourceService ccrRestoreService;

        @Inject
        public TransportPutCcrRestoreSessionAction(ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver resolver, TransportService transportService, IndicesService indicesService, CcrRestoreSourceService ccrRestoreService) {
            super(PutCcrRestoreSessionAction.NAME, threadPool, clusterService, transportService, actionFilters, resolver, PutCcrRestoreSessionRequest::new, "generic");
            this.indicesService = indicesService;
            this.ccrRestoreService = ccrRestoreService;
        }

        protected PutCcrRestoreSessionResponse shardOperation(PutCcrRestoreSessionRequest request, ShardId shardId) throws IOException {
            IndexShard indexShard = (IndexShard)this.indicesService.getShardOrNull(shardId);
            if (indexShard == null) {
                throw new ShardNotFoundException(shardId);
            }
            Store.MetadataSnapshot storeFileMetaData = this.ccrRestoreService.openSession(request.getSessionUUID(), indexShard);
            long mappingVersion = indexShard.indexSettings().getIndexMetaData().getMappingVersion();
            return new PutCcrRestoreSessionResponse(this.clusterService.localNode(), storeFileMetaData, mappingVersion);
        }

        protected PutCcrRestoreSessionResponse newResponse() {
            return new PutCcrRestoreSessionResponse();
        }

        protected boolean resolveIndex(PutCcrRestoreSessionRequest request) {
            return false;
        }

        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            ShardId shardId = ((PutCcrRestoreSessionRequest)request.request()).getShardId();
            return state.routingTable().shardRoutingTable(shardId).primaryShardIt();
        }
    }
}

