/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasablePagedBytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.repositories.GetCcrRestoreFileChunkRequest;
import org.elasticsearch.xpack.ccr.repository.CcrRestoreSourceService;

public class GetCcrRestoreFileChunkAction
extends Action<GetCcrRestoreFileChunkResponse> {
    public static final GetCcrRestoreFileChunkAction INSTANCE = new GetCcrRestoreFileChunkAction();
    public static final String NAME = "internal:admin/ccr/restore/file_chunk/get";

    private GetCcrRestoreFileChunkAction() {
        super(NAME);
    }

    public GetCcrRestoreFileChunkResponse newResponse() {
        throw new UnsupportedOperationException();
    }

    public Writeable.Reader<GetCcrRestoreFileChunkResponse> getResponseReader() {
        return GetCcrRestoreFileChunkResponse::new;
    }

    public static class GetCcrRestoreFileChunkResponse
    extends ActionResponse {
        private final long offset;
        private final BytesReference chunk;

        GetCcrRestoreFileChunkResponse(StreamInput streamInput) throws IOException {
            super(streamInput);
            this.offset = streamInput.readVLong();
            this.chunk = streamInput.readBytesReference();
        }

        GetCcrRestoreFileChunkResponse(long offset, BytesReference chunk) {
            this.offset = offset;
            this.chunk = chunk;
        }

        public long getOffset() {
            return this.offset;
        }

        public BytesReference getChunk() {
            return this.chunk;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.offset);
            out.writeBytesReference(this.chunk);
        }
    }

    public static class TransportGetCcrRestoreFileChunkAction
    extends HandledTransportAction<GetCcrRestoreFileChunkRequest, GetCcrRestoreFileChunkResponse> {
        private final CcrRestoreSourceService restoreSourceService;
        private final BigArrays bigArrays;

        @Inject
        public TransportGetCcrRestoreFileChunkAction(BigArrays bigArrays, TransportService transportService, ActionFilters actionFilters, CcrRestoreSourceService restoreSourceService) {
            super(GetCcrRestoreFileChunkAction.NAME, transportService, actionFilters, GetCcrRestoreFileChunkRequest::new, "generic");
            TransportActionProxy.registerProxyAction((TransportService)transportService, (String)GetCcrRestoreFileChunkAction.NAME, GetCcrRestoreFileChunkResponse::new);
            this.restoreSourceService = restoreSourceService;
            this.bigArrays = bigArrays;
        }

        protected void doExecute(Task task, GetCcrRestoreFileChunkRequest request, ActionListener<GetCcrRestoreFileChunkResponse> listener) {
            int bytesRequested = request.getSize();
            ByteArray array = this.bigArrays.newByteArray((long)bytesRequested, false);
            String fileName = request.getFileName();
            String sessionUUID = request.getSessionUUID();
            try (ReleasablePagedBytesReference reference = new ReleasablePagedBytesReference(array, bytesRequested, (Releasable)array);
                 CcrRestoreSourceService.SessionReader sessionReader = this.restoreSourceService.getSessionReader(sessionUUID);){
                long offsetAfterRead = sessionReader.readFileBytes(fileName, (BytesReference)reference);
                long offsetBeforeRead = offsetAfterRead - (long)reference.length();
                listener.onResponse((Object)new GetCcrRestoreFileChunkResponse(offsetBeforeRead, (BytesReference)reference));
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        }
    }
}

