/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.repositories.DeleteInternalCcrRepositoryRequest;

public class DeleteInternalCcrRepositoryAction
extends Action<DeleteInternalCcrRepositoryResponse> {
    public static final DeleteInternalCcrRepositoryAction INSTANCE = new DeleteInternalCcrRepositoryAction();
    public static final String NAME = "internal:admin/ccr/internal_repository/delete";

    private DeleteInternalCcrRepositoryAction() {
        super(NAME);
    }

    public DeleteInternalCcrRepositoryResponse newResponse() {
        throw new UnsupportedOperationException();
    }

    public Writeable.Reader<DeleteInternalCcrRepositoryResponse> getResponseReader() {
        return DeleteInternalCcrRepositoryResponse::new;
    }

    public static class DeleteInternalCcrRepositoryResponse
    extends ActionResponse {
        DeleteInternalCcrRepositoryResponse() {
        }

        DeleteInternalCcrRepositoryResponse(StreamInput streamInput) throws IOException {
            super(streamInput);
        }
    }

    public static class TransportDeleteInternalRepositoryAction
    extends TransportAction<DeleteInternalCcrRepositoryRequest, DeleteInternalCcrRepositoryResponse> {
        private final RepositoriesService repositoriesService;

        @Inject
        public TransportDeleteInternalRepositoryAction(RepositoriesService repositoriesService, ActionFilters actionFilters, TransportService transportService) {
            super(DeleteInternalCcrRepositoryAction.NAME, actionFilters, transportService.getTaskManager());
            this.repositoriesService = repositoriesService;
        }

        protected void doExecute(Task task, DeleteInternalCcrRepositoryRequest request, ActionListener<DeleteInternalCcrRepositoryResponse> listener) {
            this.repositoriesService.unregisterInternalRepository(request.getName());
            listener.onResponse((Object)new DeleteInternalCcrRepositoryResponse());
        }
    }
}

