/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.bulk.BulkShardOperationsRequest;
import org.elasticsearch.xpack.ccr.action.bulk.BulkShardOperationsResponse;
import org.elasticsearch.xpack.ccr.index.engine.AlreadyProcessedFollowingEngineException;

public class TransportBulkShardOperationsAction
extends TransportWriteAction<BulkShardOperationsRequest, BulkShardOperationsRequest, BulkShardOperationsResponse> {
    @Inject
    public TransportBulkShardOperationsAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/write/bulk_shard_operations[s]", transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, BulkShardOperationsRequest::new, BulkShardOperationsRequest::new, "write");
    }

    protected TransportWriteAction.WritePrimaryResult<BulkShardOperationsRequest, BulkShardOperationsResponse> shardOperationOnPrimary(BulkShardOperationsRequest request, IndexShard primary) throws Exception {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("index [{}] on the following primary shard {}", request.getOperations(), (Object)primary.routingEntry());
        }
        return TransportBulkShardOperationsAction.shardOperationOnPrimary(request.shardId(), request.getHistoryUUID(), request.getOperations(), request.getMaxSeqNoOfUpdatesOrDeletes(), primary, this.logger);
    }

    public static Translog.Operation rewriteOperationWithPrimaryTerm(Translog.Operation operation, long primaryTerm) {
        Translog.NoOp operationWithPrimaryTerm;
        switch (operation.opType()) {
            case INDEX: {
                Translog.Index index = (Translog.Index)operation;
                operationWithPrimaryTerm = new Translog.Index(index.type(), index.id(), index.seqNo(), primaryTerm, index.version(), BytesReference.toBytes((BytesReference)index.source()), index.routing(), index.getAutoGeneratedIdTimestamp());
                break;
            }
            case DELETE: {
                Translog.Delete delete = (Translog.Delete)operation;
                operationWithPrimaryTerm = new Translog.Delete(delete.type(), delete.id(), delete.uid(), delete.seqNo(), primaryTerm, delete.version());
                break;
            }
            case NO_OP: {
                Translog.NoOp noOp = (Translog.NoOp)operation;
                operationWithPrimaryTerm = new Translog.NoOp(noOp.seqNo(), primaryTerm, noOp.reason());
                break;
            }
            default: {
                throw new IllegalStateException("unexpected operation type [" + operation.opType() + "]");
            }
        }
        return operationWithPrimaryTerm;
    }

    public static CcrWritePrimaryResult shardOperationOnPrimary(ShardId shardId, String historyUUID, List<Translog.Operation> sourceOperations, long maxSeqNoOfUpdatesOrDeletes, IndexShard primary, Logger logger) throws IOException {
        if (!historyUUID.equalsIgnoreCase(primary.getHistoryUUID())) {
            throw new IllegalStateException("unexpected history uuid, expected [" + historyUUID + "], actual [" + primary.getHistoryUUID() + "], shard is likely restored from snapshot or force allocated");
        }
        assert (maxSeqNoOfUpdatesOrDeletes >= -1L) : "invalid msu [" + maxSeqNoOfUpdatesOrDeletes + "]";
        primary.advanceMaxSeqNoOfUpdatesOrDeletes(maxSeqNoOfUpdatesOrDeletes);
        ArrayList<Translog.Operation> appliedOperations = new ArrayList<Translog.Operation>(sourceOperations.size());
        Translog.Location location = null;
        for (Translog.Operation sourceOp : sourceOperations) {
            Translog.Operation targetOp = TransportBulkShardOperationsAction.rewriteOperationWithPrimaryTerm(sourceOp, primary.getOperationPrimaryTerm());
            Engine.Result result = primary.applyTranslogOperation(targetOp, Engine.Operation.Origin.PRIMARY);
            if (result.getResultType() == Engine.Result.Type.SUCCESS) {
                assert (result.getSeqNo() == targetOp.seqNo());
                appliedOperations.add(targetOp);
                location = TransportBulkShardOperationsAction.locationToSync(location, (Translog.Location)result.getTranslogLocation());
                continue;
            }
            if (result.getFailure() instanceof AlreadyProcessedFollowingEngineException) {
                AlreadyProcessedFollowingEngineException failure = (AlreadyProcessedFollowingEngineException)((Object)result.getFailure());
                if (logger.isTraceEnabled()) {
                    logger.trace("operation [{}] was processed before on following primary shard {} with existing term {}", (Object)targetOp, (Object)primary.routingEntry(), (Object)failure.getExistingPrimaryTerm());
                }
                assert (failure.getSeqNo() == targetOp.seqNo()) : targetOp.seqNo() + " != " + failure.getSeqNo();
                if (failure.getExistingPrimaryTerm().isPresent()) {
                    appliedOperations.add(TransportBulkShardOperationsAction.rewriteOperationWithPrimaryTerm(sourceOp, failure.getExistingPrimaryTerm().getAsLong()));
                    continue;
                }
                if (targetOp.seqNo() <= primary.getGlobalCheckpoint()) continue;
                assert (false) : "can't find primary_term for existing op=" + targetOp + " gcp=" + primary.getGlobalCheckpoint();
                throw new IllegalStateException("can't find primary_term for existing op=" + targetOp + " global_checkpoint=" + primary.getGlobalCheckpoint(), (Throwable)((Object)failure));
            }
            assert (false) : "Only already-processed error should happen; op=[" + targetOp + "] error=[" + result.getFailure() + "]";
            throw ExceptionsHelper.convertToElastic((Exception)result.getFailure());
        }
        BulkShardOperationsRequest replicaRequest = new BulkShardOperationsRequest(shardId, historyUUID, appliedOperations, maxSeqNoOfUpdatesOrDeletes);
        return new CcrWritePrimaryResult(replicaRequest, location, primary, logger);
    }

    protected TransportWriteAction.WriteReplicaResult<BulkShardOperationsRequest> shardOperationOnReplica(BulkShardOperationsRequest request, IndexShard replica) throws Exception {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("index [{}] on the following replica shard {}", request.getOperations(), (Object)replica.routingEntry());
        }
        return TransportBulkShardOperationsAction.shardOperationOnReplica(request, replica, this.logger);
    }

    public static TransportWriteAction.WriteReplicaResult<BulkShardOperationsRequest> shardOperationOnReplica(BulkShardOperationsRequest request, IndexShard replica, Logger logger) throws IOException {
        assert (replica.getMaxSeqNoOfUpdatesOrDeletes() >= request.getMaxSeqNoOfUpdatesOrDeletes()) : "mus on replica [" + replica + "] < mus of request [" + request.getMaxSeqNoOfUpdatesOrDeletes() + "]";
        Translog.Location location = null;
        for (Translog.Operation operation : request.getOperations()) {
            Engine.Result result = replica.applyTranslogOperation(operation, Engine.Operation.Origin.REPLICA);
            if (result.getResultType() != Engine.Result.Type.SUCCESS) {
                assert (false) : "doc-level failure must not happen on replicas; op[" + operation + "] error[" + result.getFailure() + "]";
                throw ExceptionsHelper.convertToElastic((Exception)result.getFailure());
            }
            assert (result.getSeqNo() == operation.seqNo());
            location = TransportBulkShardOperationsAction.locationToSync(location, (Translog.Location)result.getTranslogLocation());
        }
        assert (request.getOperations().size() == 0 || location != null);
        return new TransportWriteAction.WriteReplicaResult((ReplicatedWriteRequest)request, location, null, replica, logger);
    }

    protected BulkShardOperationsResponse newResponseInstance() {
        return new BulkShardOperationsResponse();
    }

    static final class CcrWritePrimaryResult
    extends TransportWriteAction.WritePrimaryResult<BulkShardOperationsRequest, BulkShardOperationsResponse> {
        CcrWritePrimaryResult(BulkShardOperationsRequest request, Translog.Location location, IndexShard primary, Logger logger) {
            super((ReplicatedWriteRequest)request, (ReplicationResponse)new BulkShardOperationsResponse(), location, null, primary, logger);
        }

        public synchronized void respond(ActionListener<BulkShardOperationsResponse> listener) {
            ActionListener wrappedListener = ActionListener.wrap(response -> {
                SeqNoStats seqNoStats = this.primary.seqNoStats();
                response.setGlobalCheckpoint(seqNoStats.getGlobalCheckpoint());
                response.setMaxSeqNo(seqNoStats.getMaxSeqNo());
                listener.onResponse((Object)response);
            }, arg_0 -> listener.onFailure(arg_0));
            super.respond(wrappedListener);
        }
    }
}

